/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.new_engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.SearchedElementWrapper;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDummyVariable;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfNamedElementVisitor2Adapter;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfReferencesUtils;

public class ReferenceNamedElementVisitor
extends RfNamedElementVisitor2Adapter {
    private IRfNamedElement fRfElement;
    private ParserPath fCurrentParserPath;
    private boolean fIncludeDeclarations;
    private IProject fProject;
    private DocumentManager fDocumentManager;
    private IProgressMonitor fProgressMonitor;
    private int fCheckForQueryInterruptionCounter = 0;
    private IReportHitsListener<SearchHit> fListener;
    private FileSynchedAndAvailableManager fFileManager;
    private SearchedElementWrapper fSearchedElementWrapper;
    private boolean fSkipImplicitComponentEntityAssociation;
    private boolean assumeHitWhenSameNameAndType;

    public ReferenceNamedElementVisitor(IReportHitsListener<SearchHit> listener, IProgressMonitor progressMonitor, FileSynchedAndAvailableManager fileManager, IRfNamedElement element, boolean includeDeclarations, IProject project, DocumentManager documentManager, SearchedElementWrapper searchedElementWrapper, boolean skipImplicitComponentEntityAssociation) {
        this.fRfElement = element;
        this.fProject = project;
        this.fIncludeDeclarations = includeDeclarations;
        this.fFileManager = fileManager;
        this.fListener = listener;
        this.fDocumentManager = documentManager;
        this.fProgressMonitor = progressMonitor;
        this.fSearchedElementWrapper = searchedElementWrapper;
        this.fSkipImplicitComponentEntityAssociation = skipImplicitComponentEntityAssociation;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean visit(RfNamedElement element) {
        try {
            boolean sameTypeOfElement;
            if (this.fCheckForQueryInterruptionCounter++ == 20) {
                if (this.fProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException("Operation Canceled");
                }
                this.fCheckForQueryInterruptionCounter = 0;
            }
            boolean bl = sameTypeOfElement = !(this.fRfElement instanceof RfNamedElement) || this.fRfElement.getClass().getName().equals(element.getClass().getName());
            if (!this.fSkipImplicitComponentEntityAssociation && element.checkEquals(this.fRfElement) || this.assumeHitWhenSameNameAndType && (element instanceof IRfDesignElement && this.fRfElement instanceof IRfDesignElement || element instanceof IRfPortElement && this.fRfElement instanceof IRfPortElement || element instanceof IRfFieldElement && this.fRfElement instanceof IRfFieldElement) && element.getLowerCaseName().equals(this.fRfElement.getLowerCaseName()) || this.fSkipImplicitComponentEntityAssociation && element.equals(this.fRfElement)) {
                Collection<? extends RfDefElement> declarations = element.getDeclarations();
                if (declarations == null || declarations.isEmpty()) {
                    return true;
                }
                for (IRfDefElement iRfDefElement : declarations) {
                    boolean searchForDeclaration;
                    if (!(iRfDefElement instanceof RfDefElement)) continue;
                    RfDefElement rfDefElement = (RfDefElement)iRfDefElement;
                    if (rfDefElement instanceof RfFileDef) {
                        return true;
                    }
                    ParserPath parserPath = rfDefElement.getParserPath();
                    if (!this.fFileManager.isSynchedFile(parserPath, this.fProject)) continue;
                    boolean isDeclaration = false;
                    if (sameTypeOfElement) {
                        isDeclaration = this.isDeclaration(rfDefElement, element, parserPath);
                    }
                    RWKind writeAccess = this.computeWriteAccessForDeclaration(element);
                    boolean bl2 = searchForDeclaration = this.fIncludeDeclarations || !isDeclaration || writeAccess != RWKind.NONE;
                    if (!searchForDeclaration) continue;
                    this.addMatchDef(false, element, rfDefElement, writeAccess);
                }
                return true;
            }
            if (element instanceof RfAssociatedType) {
                DataTypeChunk dataTypeChunck = this.computeDataTypeChunckHit((RfAssociatedType)element);
                if (dataTypeChunck == null) {
                    return true;
                }
                Collection<? extends RfDefElement> collection = element.getDeclarations();
                if (collection == null || collection.isEmpty()) {
                    return true;
                }
                for (IRfDefElement iRfDefElement : collection) {
                    if (!(iRfDefElement instanceof RfDefElement)) continue;
                    RfDefElement defElement = (RfDefElement)iRfDefElement;
                    if (defElement instanceof RfFileDef) {
                        return true;
                    }
                    this.addMatchAssocType(dataTypeChunck, false, defElement);
                }
            } else if (element instanceof RfType) {
                DataType type = ((RfType)element).getDataType();
                if (type == null) {
                    return true;
                }
                IRfNamedElement iRfNamedElement = VHDLRfReferencesUtils.getNamedElementOfDataType(element, type, 0, null);
                if (this.fRfElement.checkEquals((Object)iRfNamedElement)) {
                    Collection<? extends RfDefElement> collection = element.getDeclarations();
                    if (collection == null || collection.isEmpty()) {
                        return true;
                    }
                    for (IRfDefElement iRfDefElement : collection) {
                        if (!(iRfDefElement instanceof RfDefElement)) continue;
                        RfDefElement defElement = (RfDefElement)iRfDefElement;
                        this.addMatchAssocType(type.getLastDataTypeChunk(), false, defElement);
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private RWKind computeWriteAccessForDeclaration(IRfNamedElement element) {
        if (VHDLRfReferencesUtils.canBeReadOrWritten((IRfNamedElement)element)) {
            if (((IRfFieldElement)element).getInitialValue(false) != null && !((IRfFieldElement)element).getInitialValue(false).isEmpty()) {
                return RWKind.WRITE;
            }
            if (element.getEnclosingScope() instanceof RfActionBlock && ((RfActionBlock)element.getEnclosingScope()).isFor()) {
                return RWKind.READ_WRITE;
            }
        }
        return RWKind.NONE;
    }

    private DataTypeChunk computeDataTypeChunckHit(RfAssociatedType element) {
        IRfNamedElement resolvedType;
        DataType dataType = element.getDataType();
        if (element instanceof RfAlias) {
            IRfNamedElement assocType;
            List<IRfNamedElement> elementChuncks = ((RfAlias)element).getTranslatedElementChunks();
            if (elementChuncks == null || elementChuncks.isEmpty()) {
                return null;
            }
            DataType aliasedDataType = ((RfAlias)element).getAliasedDataType();
            if (aliasedDataType != null) {
                int i = 0;
                while (i < elementChuncks.size()) {
                    IRfNamedElement elementChunck = elementChuncks.get(i);
                    if (this.fRfElement.checkEquals((Object)elementChunck) || this.assumeHitWhenSameNameAndType) {
                        return aliasedDataType.getDataTypeChunk(i);
                    }
                    ++i;
                }
            }
            if ((assocType = ((RfAlias)element).getAssociatedType()) instanceof RfDummyVariable) {
                assocType = ((RfDummyVariable)assocType).getAssociatedType();
            }
            if (!this.fSkipImplicitComponentEntityAssociation && this.fRfElement.checkEquals((Object)assocType) || this.fSkipImplicitComponentEntityAssociation && this.fRfElement.equals(assocType)) {
                if (dataType == null) {
                    return null;
                }
                DataTypeChunk lastDataTypeChunk = dataType.getLastDataTypeChunk();
                if (lastDataTypeChunk == null || lastDataTypeChunk.name == null) {
                    return null;
                }
                return this.fRfElement.getLowerCaseName().equals(lastDataTypeChunk.name.toLowerCase()) ? lastDataTypeChunk : null;
            }
        }
        if ((resolvedType = element.getResolvedType(true)) == null) {
            return null;
        }
        if (!this.fSkipImplicitComponentEntityAssociation && this.fRfElement.checkEquals((Object)resolvedType) || this.assumeHitWhenSameNameAndType && element instanceof IRfDesignElement && this.fRfElement instanceof IRfDesignElement || this.fSkipImplicitComponentEntityAssociation && this.fRfElement.equals(resolvedType)) {
            if (dataType == null) {
                return null;
            }
            DataTypeChunk lastDataTypeChunk = dataType.getLastDataTypeChunk();
            if (lastDataTypeChunk == null || lastDataTypeChunk.name == null) {
                return null;
            }
            return this.fRfElement.getLowerCaseName().equals(lastDataTypeChunk.name.toLowerCase()) || this.assumeHitWhenSameNameAndType ? lastDataTypeChunk : null;
        }
        if (dataType == null) {
            return null;
        }
        int nofChuncks = dataType.getNofChuncks();
        if (nofChuncks > 1) {
            if (this.fRfElement.checkEquals((Object)resolvedType.getEnclosingScope())) {
                DataTypeChunk dataTypeChunk = dataType.getDataTypeChunk(nofChuncks - 2);
                if (dataTypeChunk == null || dataTypeChunk.name == null) {
                    return null;
                }
                return this.fRfElement.getLowerCaseName().equals(dataTypeChunk.name.toLowerCase()) ? dataTypeChunk : null;
            }
            if (nofChuncks == 3 && this.fRfElement.checkEquals((Object)resolvedType.getEnclosingLibrary())) {
                DataTypeChunk firstDataTypeChunk = dataType.getFirstDataTypeChunk();
                if (firstDataTypeChunk == null || firstDataTypeChunk.name == null) {
                    return null;
                }
                return this.fRfElement.getLowerCaseName().equals(firstDataTypeChunk.name.toLowerCase()) ? firstDataTypeChunk : null;
            }
        }
        return null;
    }

    private void addMatchAssocType(DataTypeChunk dataTypeChunck, boolean isPossibleMatch, RfDefElement defElement) throws Exception {
        RfNamedElement namedElement;
        if (dataTypeChunck == null) {
            return;
        }
        ParserPath parserPath = defElement.getParserPath();
        if (parserPath == null) {
            return;
        }
        if (!this.fFileManager.isSynchedFile(parserPath, this.fProject)) {
            return;
        }
        if (!parserPath.equals((Object)this.fCurrentParserPath)) {
            this.fCurrentParserPath = parserPath;
        }
        int matchLength = dataTypeChunck.name.length();
        int offset = dataTypeChunck.offset;
        if (offset == -1) {
            return;
        }
        IDocument document = this.fDocumentManager.getDocument(this.fCurrentParserPath, this.fProject);
        if (document == null) {
            return;
        }
        int startOffsetLine = document.getLineOfOffset(offset);
        IRegion startLineInfo = document.getLineInformation(startOffsetLine);
        int lineStart = document.getLineOffset(startOffsetLine);
        String lineContents = document.get(startLineInfo.getOffset(), startLineInfo.getLength());
        SearchHit lineEntry = new SearchHit(parserPath, startOffsetLine + 1, offset, lineContents, matchLength, this.fProject);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)(startOffsetLine + 1), (int)offset, (boolean)isPossibleMatch));
        int counter = VHDLRfReferencesUtils.countStartWS((String)lineContents);
        int highlightOffset = offset;
        if (counter >= 0) {
            lineEntry.setSearchedElement(dataTypeChunck.name, highlightOffset - lineStart - counter, isPossibleMatch);
        }
        if ((namedElement = defElement.getNamedElement()) instanceof RfInstance) {
            lineEntry.setInstance((IRfInstanceElement)((RfInstance)namedElement));
            VHDLRfReferencesUtils.changeToPostConfigHit((IProject)this.fProject, (IRfInstanceElement)((RfInstance)namedElement), (SearchHit)lineEntry);
        }
        this.fListener.addMatch((Object)lineEntry);
    }

    private void addMatchDef(boolean isPossibleMatch, RfNamedElement element, RfDefElement defElement, RWKind writeAccess) throws Exception {
        IDocument openDocument;
        ParserPath parserPath = defElement.getParserPath();
        if (!this.fFileManager.isSynchedFile(parserPath, this.fProject)) {
            return;
        }
        if (!parserPath.equals((Object)this.fCurrentParserPath)) {
            this.fCurrentParserPath = parserPath;
        }
        if ((openDocument = this.fDocumentManager.getDocument(this.fCurrentParserPath, this.fProject)) == null) {
            return;
        }
        int line = defElement.getStartLabelLine();
        int offset = defElement.getStartLabelOffset();
        int matchLength = this.fRfElement.getName().length();
        if (line < 1) {
            return;
        }
        IRegion lineRegion = openDocument.getLineInformation(line - 1);
        String lineContents = openDocument.get(lineRegion.getOffset(), lineRegion.getLength());
        if (element.isEscaped()) {
            ++matchLength;
        }
        SearchHit lineEntry = new SearchHit(parserPath, line, offset, lineContents, matchLength, this.fSearchedElementWrapper == null ? true : this.fSearchedElementWrapper.shouldBeRenamed(), null, this.fRfElement, this.fProject);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)defElement.getParserPath(), (int)line, (int)offset, (boolean)isPossibleMatch));
        lineEntry.setAccess(writeAccess);
        int lineStart = openDocument.getLineOffset(line - 1);
        int counter = VHDLRfReferencesUtils.countStartWS((String)lineContents);
        if (element.isEscaped()) {
            ++offset;
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(this.fRfElement.getName(), offset - lineStart - counter, isPossibleMatch);
        }
        this.fListener.addMatch((Object)lineEntry);
        if (defElement.hasEndLabel()) {
            offset = defElement.getEndLabelOffset();
            line = openDocument.getLineOfOffset(offset);
            lineStart = openDocument.getLineOffset(line);
            lineRegion = openDocument.getLineInformation(line);
            lineContents = openDocument.get(lineRegion.getOffset(), lineRegion.getLength());
            lineEntry = new SearchHit(parserPath, line + 1, offset, lineContents, matchLength, this.fSearchedElementWrapper == null ? true : this.fSearchedElementWrapper.shouldBeRenamed(), null, this.fRfElement, this.fProject);
            lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)defElement.getParserPath(), (int)(line + 1), (int)offset, (boolean)isPossibleMatch));
            counter = VHDLRfReferencesUtils.countStartWS((String)lineContents);
            if (counter >= 0) {
                lineEntry.setSearchedElement(this.fRfElement.getName(), offset - lineStart - counter, isPossibleMatch);
            }
            this.fListener.addMatch((Object)lineEntry);
        }
    }

    private boolean isDeclaration(RfDefElement defElement, IRfNamedElement element, ParserPath parserPath) throws Exception {
        IDocument document = this.fDocumentManager.getDocument(parserPath, this.fProject);
        if (document == null) {
            return false;
        }
        return this.checkDeclaration(defElement, element, parserPath, document);
    }

    private boolean checkDeclaration(RfDefElement defElement, IRfNamedElement element, ParserPath parserPath, IDocument openDocument) throws Exception {
        int startOffsetLine = openDocument.getLineOfOffset(defElement.getStartOffset());
        int currentMatchStartLine = startOffsetLine + 1;
        int endOffsetLine = openDocument.getLineOfOffset(defElement.getEndOffset());
        if (element instanceof RfNamedElement) {
            ArrayList<RfDefElement> declarations = new ArrayList<RfDefElement>(this.fRfElement.getDeclarations());
            if (this.fRfElement instanceof RfFunction) {
                if (((RfFunction)this.fRfElement).isPrototype()) {
                    RfFunction rfFunction = ((RfFunction)this.fRfElement).getImplementation();
                    if (rfFunction != this.fRfElement) {
                        declarations.addAll(rfFunction.getDeclarations());
                    }
                } else {
                    RfFunction rfFunction = ((RfFunction)this.fRfElement).getPrototype();
                    if (rfFunction != this.fRfElement) {
                        declarations.addAll(rfFunction.getDeclarations());
                    }
                }
            }
            if (this.fRfElement instanceof RfVariable && ((RfVariable)this.fRfElement).getInterfaceKind() != 1) {
                RfVariable rfVariable = (RfVariable)this.fRfElement;
                if (rfVariable.isPrototype()) {
                    declarations.add(rfVariable.getImplementation().getDeclaration());
                } else {
                    declarations.add(rfVariable.getPrototype().getDeclaration());
                }
            }
            for (IRfDefElement iRfDefElement : declarations) {
                if (iRfDefElement.getDefFile() == null || !iRfDefElement.getDefFile().getParserPath().equals((Object)parserPath) || iRfDefElement.getStartLine() != currentMatchStartLine && openDocument.getLineOfOffset(iRfDefElement.getEndOffset()) != endOffsetLine) continue;
                return true;
            }
        } else {
            IRfDefElement typeLayer = this.fRfElement.getDeclaration();
            if (typeLayer.getDefFile() != null && typeLayer.getDefFile().getParserPath().equals((Object)parserPath) && (typeLayer.getStartLine() == currentMatchStartLine || openDocument.getLineOfOffset(typeLayer.getEndOffset()) == endOffsetLine)) {
                return true;
            }
        }
        return false;
    }

    public void setAssumeHitWhenSameNameAndType() {
        this.assumeHitWhenSameNameAndType = true;
    }
}

