/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.new_engine;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfReferencesUtils;

public class ReportHidOperatorVisitor
implements IHidVisitor<RfHidOperator> {
    private static final String REPORT_KEYWORD = "report";
    private ParserPath fParserPath;
    private int fCheckForQueryInterruptionCounter = 0;
    private IProgressMonitor fProgressMonitor;
    private DocumentManager fDocumentManager;
    private IReportHitsListener<SearchHit> fListener;
    private IProject fProject;
    private FileSynchedAndAvailableManager fFileManager;

    public ReportHidOperatorVisitor(IProgressMonitor progressMonitor, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, IReportHitsListener<SearchHit> reportHitsListener, IProject project) {
        this.fProgressMonitor = progressMonitor;
        this.fDocumentManager = documentManager;
        this.fListener = reportHitsListener;
        this.fProject = project;
        this.fFileManager = fileManager;
    }

    public boolean visit(RfHidOperator hidOperator) {
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        if (!hidOperator.isReport()) {
            return true;
        }
        this.addMatch(hidOperator);
        return true;
    }

    private void addMatch(RfHidOperator hidOperator) {
        try {
            if (!this.fFileManager.isSynchedFile(this.fParserPath, this.fProject)) {
                return;
            }
            IDocument document = this.fDocumentManager.getDocument(this.fParserPath, this.fProject);
            if (document == null) {
                return;
            }
            int line = hidOperator.getOccurrence().getLine();
            IRegion lineInformation = document.getLineInformation(line - 1);
            if (lineInformation == null) {
                return;
            }
            String lineContents = document.get(lineInformation.getOffset(), lineInformation.getLength());
            int lineStart = lineInformation.getOffset();
            int index = lineContents.toLowerCase().indexOf(REPORT_KEYWORD);
            if (index == -1) {
                return;
            }
            int offset = index + lineStart;
            SearchHit searchHit = new SearchHit(this.fParserPath, line, offset, lineContents, REPORT_KEYWORD.length(), this.fProject);
            int counter = VHDLRfReferencesUtils.countStartWS((IDocument)document, (IRegion)lineInformation);
            if (counter >= 0) {
                searchHit.setSearchedElement(REPORT_KEYWORD, offset - lineStart - counter, false);
            }
            this.fListener.addMatch((Object)searchHit);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setParserPath(ParserPath parserPath) {
        this.fParserPath = parserPath;
    }
}

