/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.new_engine;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.ui.search.HidMatch;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;

class SignalReadWriteVisitor
implements IHidVisitor<RfHidOperator> {
    private static final long ASSIGN_QUALIFIERS = HidUtils.toQualifiersSet((HidOperatorQualifier[])new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_EXPRESSION, HidOperatorQualifier.IS_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_BLOCKING_ASSIGN});
    private static final Set<HidFlatteningOption> FLATTENING_OPTIONS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));
    private Map<Hid, HidMatch> rwMap;

    public SignalReadWriteVisitor(Map<Hid, HidMatch> rwMap) {
        this.rwMap = rwMap;
    }

    public boolean visit(RfHidOperator operator) {
        boolean isPortArgumentConnection;
        boolean hasAssignQualifier = operator.hasOccurrence(ASSIGN_QUALIFIERS);
        boolean isRelease = operator.hasOccurrence(HidOperatorQualifier.IS_PROCEDURAL_CONTINUOUS_ASSIGN);
        boolean isIncrementOrDecrement = operator.isIncrementOrDecrement();
        boolean isEventTrigger = operator.hasOccurrence(HidOperatorQualifier.IS_EVENT_TRIGGER);
        boolean isPatternAssign = operator.hasOccurrence(HidOperatorQualifier.IS_PATTERN_VALUE);
        boolean bl = isPortArgumentConnection = operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION) || operator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE);
        if (isPatternAssign) {
            this.computeWriteAccessInPatternAssign(operator);
        } else if (isEventTrigger || isIncrementOrDecrement) {
            this.computeWriteAccessInEventAndIncrementDecrementOperator(operator, isIncrementOrDecrement);
        } else if (hasAssignQualifier || isRelease) {
            this.computeWriteAccessForAssigns(operator);
        } else if (isPortArgumentConnection) {
            this.computePortArgumentConnectionOperator(operator);
        }
        return true;
    }

    private void computePortArgumentConnectionOperator(RfHidOperator operator) {
        Set lhHids = operator.getLHHids(FLATTENING_OPTIONS);
        Hid leftHandHid = null;
        for (IHid hid : lhHids) {
            leftHandHid = (Hid)hid;
            HidMatch hidMatch = this.rwMap.get(hid);
            if (hidMatch == null) continue;
            HidOccurrence occ = hid.getOccurrence();
            RWKind elementWriteType = RfReferencesUtils.getPortElementWriteType((IRfNamedElement)hid.getElement());
            if (elementWriteType == RWKind.READ_WRITE) {
                hidMatch.addReadOccurence(occ);
                hidMatch.addWriteOccurence(occ);
                continue;
            }
            if (elementWriteType == RWKind.READ) {
                hidMatch.addReadOccurence(occ);
                continue;
            }
            if (elementWriteType != RWKind.WRITE) continue;
            hidMatch.addWriteOccurence(occ);
        }
        if (leftHandHid == null) {
            return;
        }
        Set rhHids = operator.getRHHids(FLATTENING_OPTIONS);
        for (IHid hid : rhHids) {
            IRfNamedElement currentHidElement;
            HidMatch hidMatch = this.rwMap.get(hid);
            if (hidMatch == null) continue;
            HidOccurrence occ = hid.getOccurrence();
            IRfNamedElement lhHidElement = leftHandHid.getElement();
            RWKind elementWriteType = RfSearchUtils.computePortArgumentConnectionWriteAccess((IRfNamedElement)lhHidElement, (IRfNamedElement)(currentHidElement = hid.getElement()), (boolean)true, (RWKind)RfReferencesUtils.getPortElementWriteType((IRfNamedElement)currentHidElement));
            if (elementWriteType == RWKind.READ_WRITE) {
                hidMatch.addReadOccurence(occ);
                hidMatch.addWriteOccurence(occ);
                continue;
            }
            if (elementWriteType == RWKind.READ) {
                hidMatch.addReadOccurence(occ);
                continue;
            }
            if (elementWriteType != RWKind.WRITE) continue;
            hidMatch.addWriteOccurence(occ);
        }
    }

    private void computeWriteAccessForAssigns(RfHidOperator operator) {
        Set lhHids = operator.getLHHids(FLATTENING_OPTIONS);
        for (IHid hid : lhHids) {
            HidOccurrence occ;
            HidMatch hidMatch = this.rwMap.get(hid);
            if (hidMatch == null || !SignalReadWriteVisitor.isLeftHandSide(occ = hid.getOccurrence(), operator)) continue;
            hidMatch.addWriteOccurence(occ);
        }
    }

    private void computeWriteAccessInEventAndIncrementDecrementOperator(RfHidOperator operator, boolean isIncrementOrDecrement) {
        Set lhHids = operator.getLHHids(FLATTENING_OPTIONS);
        for (IHid hid : lhHids) {
            HidMatch hidMatch = this.rwMap.get(hid);
            if (hidMatch == null) continue;
            HidOccurrence occ = hid.getOccurrence();
            if (isIncrementOrDecrement) {
                hidMatch.addReadOccurence(occ);
                hidMatch.addWriteOccurence(occ);
                continue;
            }
            if (!this.isContained(occ, operator)) continue;
            hidMatch.addWriteOccurence(occ);
        }
    }

    private void computeWriteAccessInPatternAssign(RfHidOperator operator) {
        Set lhHids = operator.getLHHids(FLATTENING_OPTIONS);
        for (IHid hid : lhHids) {
            HidMatch hidMatch = this.rwMap.get(hid);
            if (hidMatch == null) continue;
            HidOccurrence occ = hid.getOccurrence();
            hidMatch.addWriteOccurence(occ);
        }
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    private static boolean isLeftHandSide(HidOccurrence occ, RfHidOperator operator) {
        int operatorOffset = operator.getOccurrence().getOffset();
        int operatorOpenBoundary = operator.getOpenBoundary();
        int occurrenceOffset = occ.getOffset();
        int operatorVirtualOffset = operator.getOccurrence().getVirtualOffset();
        int occurrenceVirtualOffset = occ.getVirtualOffset();
        if (occurrenceVirtualOffset != -1 && operatorVirtualOffset != -1) {
            return occurrenceVirtualOffset < operatorVirtualOffset;
        }
        return occurrenceOffset < operatorOffset && occurrenceOffset >= operatorOpenBoundary;
    }

    private boolean isContained(HidOccurrence hidOcc, HidOperator op) {
        return hidOcc.getOffset() > op.getOpenBoundary() && hidOcc.getOffset() < op.getCloseBoundary();
    }
}

