/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.text.BaseTextSearchResultCollector;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.ui.search.text.FileMatch;

public final class TextSearchResultCollector
extends BaseTextSearchResultCollector {
    public TextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly, boolean searchInBinaries) {
        super(result, isFileSearchOnly, searchInBinaries);
    }

    public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
        int matchOffset = matchRequestor.getMatchOffset();
        LineElement lineElement = this.getLineElement(matchOffset, matchRequestor);
        if (lineElement != null) {
            FileMatch fileMatch = new FileMatch(matchRequestor.getFile(), matchRequestor.getMatchOffset(), matchRequestor.getMatchLength(), false, lineElement);
            IFile file = matchRequestor.getFile();
            if (file == null) {
                return true;
            }
            IProject project = file.getProject();
            if (project == null) {
                return true;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                return true;
            }
            lineElement.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)project, (ParserPath)parserPath, (int)lineElement.getLine(), (int)lineElement.getOffset(), (boolean)lineElement.isPossibleMatch()));
            if (this.fCachedMatches != null && !this.fCachedMatches.contains((Object)fileMatch)) {
                this.fCachedMatches.add(fileMatch);
            }
        }
        return true;
    }

    protected BaseFileMatch makeMatch(IFile file) {
        return new FileMatch(file, 0, 0, false);
    }
}

