/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.smartcopy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyMorpher;
import ro.amiq.dvt.ui.smartcopy.IllegalMorphException;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtilsCommon;
import ro.amiq.dvt.ui.smartcopy.model.ISCGeneric;
import ro.amiq.dvt.ui.smartcopy.model.ISCObject;
import ro.amiq.dvt.ui.smartcopy.model.ISCPortDirection;
import ro.amiq.dvt.ui.smartcopy.model.ISCVhdlPort;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.ui.smartcopy.model.SCEntity;
import ro.amiq.vhdldt.ui.smartcopy.model.SCGeneric;
import ro.amiq.vhdldt.ui.smartcopy.model.SCPort;

public class SmartCopyMorpher
implements ISmartCopyMorpher,
ISCPortDirection {
    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    public ISCObject getGeneralForm(IRfScopeElement scope, LanguageKind lang) {
        try {
            SmartCopyMorpher.checkNonNull(scope, lang);
            if (lang != this.getLanguageKind()) {
                SmartCopyMorpher.exception();
            }
            if (!(scope instanceof RfDefElement)) {
                SmartCopyMorpher.exception();
            }
            SCEntity result = null;
            RfNamedElement elem = ((RfDefElement)scope).getNamedElement();
            if (elem instanceof RfEntity) {
                result = new SCEntity(elem);
            }
            return result;
        }
        catch (IllegalMorphException ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return null;
        }
    }

    private static void exception() {
        throw new IllegalMorphException();
    }

    private static void checkNonNull(Object ... args) {
        SmartCopyUtilsCommon.checkNonNullMorph((Object[])args);
    }

    protected static String escape(String text) {
        return SmartCopyUtilsCommon.escapeTemplateText((String)text);
    }

    public static String morphName(Object origin) {
        String name;
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof IRfNamedElement)) {
            SmartCopyMorpher.exception();
        }
        if ((name = ((IRfNamedElement)origin).getName()) == null) {
            SmartCopyMorpher.exception();
        }
        return SmartCopyMorpher.escape(name);
    }

    public static String morphPortDirection(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        String direction = ((RfPort)origin).getDirection();
        boolean hasDirection = false;
        ISCPortDirection.VHDL_DIRECTION[] vHDL_DIRECTIONArray = ISCPortDirection.VHDL_DIRECTION.values();
        int n = vHDL_DIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISCPortDirection.VHDL_DIRECTION dir = vHDL_DIRECTIONArray[n2];
            hasDirection = dir.toString().equalsIgnoreCase(direction);
            if (hasDirection) break;
            ++n2;
        }
        if (!hasDirection) {
            SmartCopyMorpher.exception();
        }
        return SmartCopyMorpher.escape(direction);
    }

    public static String morphPortType(Object origin) {
        String typeName;
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        if ((typeName = ((RfPort)origin).getAssociatedTypeName()) == null) {
            SmartCopyMorpher.exception();
        }
        return SmartCopyMorpher.escape(typeName);
    }

    public static String morphPortRange(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        String range = ((RfPort)origin).getRange();
        return SmartCopyMorpher.escape(range);
    }

    public static String morphEntityPortInitialValue(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfPort)) {
            SmartCopyMorpher.exception();
        }
        String initialValue = ((RfPort)origin).getInitialValue(false);
        return SmartCopyMorpher.escape(initialValue);
    }

    public static List<ISCVhdlPort> morphEntityPorts(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfEntity)) {
            SmartCopyMorpher.exception();
        }
        ArrayList<SCPort> mPorts = new ArrayList<SCPort>();
        SCPort mPort = null;
        RfEntity lEntity = (RfEntity)origin;
        List<RfPort> lPorts = lEntity.getLocalMembers(RfPort.class);
        if (lPorts != null) {
            for (RfPort lPort : lPorts) {
                try {
                    mPort = new SCPort(lPort);
                    mPorts.add(mPort);
                }
                catch (IllegalMorphException illegalMorphException) {}
            }
        }
        return Collections.unmodifiableList(mPorts);
    }

    public static String morphEntityGenericInitialValue(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfVariable)) {
            SmartCopyMorpher.exception();
        }
        String initialValue = ((RfVariable)origin).getInitialValue(false);
        return SmartCopyMorpher.escape(initialValue);
    }

    public static String morphEntityGenericType(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfVariable)) {
            SmartCopyMorpher.exception();
        }
        String type = ((RfVariable)origin).getAssociatedTypeName();
        return SmartCopyMorpher.escape(type);
    }

    public static String morphEntityGenericRange(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfVariable)) {
            SmartCopyMorpher.exception();
        }
        String range = ((RfVariable)origin).getRange();
        return SmartCopyMorpher.escape(range);
    }

    public static List<ISCGeneric> morphEntityGenerics(Object origin) {
        SmartCopyMorpher.checkNonNull(origin);
        if (!(origin instanceof RfEntity)) {
            SmartCopyMorpher.exception();
        }
        ArrayList<SCGeneric> mVariables = new ArrayList<SCGeneric>();
        SCGeneric mVariable = null;
        RfEntity lEntity = (RfEntity)origin;
        List<RfVariable> lVariables = lEntity.getVariablesWithPrefix("", 2, false);
        if (lVariables != null) {
            for (RfVariable lVariable : lVariables) {
                try {
                    if (!lVariable.isParameter()) continue;
                    mVariable = new SCGeneric(lVariable);
                    mVariables.add(mVariable);
                }
                catch (IllegalMorphException illegalMorphException) {}
            }
        }
        return Collections.unmodifiableList(mVariables);
    }
}

