/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.smartcopy;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.externaltools.compilescript.FreemarkerFileTemplateLoader;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyConstants;
import ro.amiq.dvt.ui.smartcopy.ISmartCopyTranslater;
import ro.amiq.dvt.ui.smartcopy.IllegalTranslateException;
import ro.amiq.dvt.ui.smartcopy.SmartCopyIdentity;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtilsCommon;
import ro.amiq.dvt.ui.smartcopy.model.ISCObject;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;
import ro.amiq.vhdldt.ui.smartcopy.SmartCopyTemplateLoader;

public class SmartCopyTranslater
implements ISmartCopyTranslater {
    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    private static void exception() {
        throw new IllegalTranslateException();
    }

    private static void checkNonNull(Object ... args) {
        SmartCopyUtilsCommon.checkNonNullTranslate((Object[])args);
    }

    public String translateToPattern(SmartCopyIdentity templateIdentity, LanguageKind langOrder, ISCObject root, boolean doFormat) {
        StringWriter writer = null;
        try {
            SmartCopyTranslater.checkNonNull(templateIdentity, langOrder, root);
            if (templateIdentity.lang != this.getLanguageKind()) {
                SmartCopyTranslater.exception();
            }
            Configuration config = this.getConfiguration(templateIdentity);
            Template template = config.getTemplate(this.getTemplatePath(templateIdentity));
            writer = new StringWriter();
            SimpleHash hash = new SimpleHash();
            hash.put("root", (Object)root);
            template.process((Object)hash, (Writer)writer);
            String result = ((Object)writer).toString();
            if (doFormat) {
                result = Utils.formatString(() -> new VhdlSourceViewerConfiguration(null), (String)result, null, (String)"", (boolean)true);
            }
            if (result == null) {
                SmartCopyTranslater.exception();
            }
            String string = result;
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)writer);
            return string;
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        finally {
            DVTUtilsCommon.INSTANCE.closeClosable(writer);
        }
        return null;
    }

    public String getTemplatePath(SmartCopyIdentity templateIdentity) {
        SmartCopyTranslater.checkNonNull(templateIdentity);
        String path = SmartCopyUtilsCommon.getTemplatePath((SmartCopyIdentity)templateIdentity);
        if (path == null) {
            SmartCopyTranslater.exception();
        }
        return path;
    }

    private Configuration getConfiguration(SmartCopyIdentity templateIdentity) {
        if (templateIdentity.operation == ISmartCopyConstants.SmartCopyOperation.PASTE_FROM_TEMPLATE) {
            Configuration config = new Configuration();
            config.setTemplateLoader((TemplateLoader)new FreemarkerFileTemplateLoader());
            return config;
        }
        Configuration config = new Configuration();
        config.setTemplateLoader((TemplateLoader)new SmartCopyTemplateLoader());
        config.addAutoImport("common", "_dvt_freemarkers_common_library.ftl");
        config.addAutoImport("vhdl", "_dvt_freemarkers_vhdl_library.ftl");
        return config;
    }
}

