/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.smartcopy.model;

import ro.amiq.dvt.ui.smartcopy.SmartCopyUtilsCommon;
import ro.amiq.dvt.ui.smartcopy.model.ISCVhdlPort;
import ro.amiq.vhdldt.ui.smartcopy.SmartCopyMorpher;
import ro.amiq.vhdldt.ui.smartcopy.model.SCObject;

public class SCPort
extends SCObject
implements ISCVhdlPort {
    private String direction;
    private String type;
    private String range;
    private String initialValue;

    public SCPort(Object origin) {
        super(origin);
    }

    public String getDirection() {
        try {
            if (this.direction == null) {
                this.direction = SmartCopyMorpher.morphPortDirection(this.origin);
            }
        }
        catch (Exception e) {
            SmartCopyUtilsCommon.logError((Throwable)e);
        }
        return SmartCopyUtilsCommon.nonNull((String)this.direction);
    }

    public String getType() {
        try {
            if (this.type == null) {
                this.type = SmartCopyMorpher.morphPortType(this.origin);
            }
        }
        catch (Exception e) {
            SmartCopyUtilsCommon.logError((Throwable)e);
        }
        return SmartCopyUtilsCommon.nonNull((String)this.type);
    }

    public String getRange() {
        try {
            if (this.range == null) {
                this.range = SmartCopyMorpher.morphPortRange(this.origin);
            }
        }
        catch (Exception e) {
            SmartCopyUtilsCommon.logError((Throwable)e);
        }
        return SmartCopyUtilsCommon.nonNull((String)this.range);
    }

    public boolean hasRange() {
        this.getRange();
        return SmartCopyUtilsCommon.hasField((String)this.range);
    }

    public boolean hasRangeConstraint() {
        this.getRange();
        return SmartCopyUtilsCommon.hasField((String)this.range) && this.range.toUpperCase().startsWith("RANGE");
    }

    public String getInitialValue() {
        try {
            if (this.initialValue == null) {
                this.initialValue = SmartCopyMorpher.morphEntityPortInitialValue(this.origin);
            }
        }
        catch (Exception e) {
            SmartCopyUtilsCommon.logError((Throwable)e);
        }
        return SmartCopyUtilsCommon.nonNull((String)this.initialValue).trim();
    }

    public boolean hasInitialValue() {
        this.getInitialValue();
        return SmartCopyUtilsCommon.hasField((String)this.initialValue);
    }
}

