/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.syntaxerrors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.vhdldt.model.problems.Bridge;
import ro.amiq.vhdldt.parser.VhdlProblem;
import ro.amiq.vhdldt.ui.syntaxerrors.SyntaxErrorsManagerCommon;

public class SyntaxErrorsManager
extends SyntaxErrorsManagerCommon {
    private static SyntaxErrorsManager fInstance;

    private SyntaxErrorsManager() {
        DVTProblemsUiUpdaterRegistry.register((DVTProblemsUiUpdater)new DVTProblemsUiUpdater(VhdlProblemCategories.VHDL_SYNTAX));
    }

    public static SyntaxErrorsManager getInstance() {
        if (fInstance == null) {
            fInstance = new SyntaxErrorsManager();
        }
        return fInstance;
    }

    @Override
    public void updateProblemsUI(IProject project, List<VhdlProblem> unreportedErrors) {
        for (VhdlProblem error : unreportedErrors) {
            DVTProblemManager.getInstance().reportProblem(Bridge.fromError(project, error, error.getFileName(), true));
        }
        DVTProblemsUiUpdaterRegistry.get((String)VhdlProblemCategories.VHDL_SYNTAX.getId()).updateOutsideErrors(project);
    }

    @Override
    protected String getFilePath(IFile file) {
        IPath location = file.getLocation();
        if (location == null) {
            return "";
        }
        return BaseUtils.canonicPath((IPath)location);
    }

    @Override
    protected void updateProblemsUI(IResource resource, int buildKind) {
        DVTProblemsUiUpdaterRegistry.get((String)VhdlProblemCategories.VHDL_SYNTAX.getId()).update((IFile)resource, buildKind == 1);
    }
}

