/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.syntaxerrors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.vhdldt.model.IVhdlReparseListener;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.problems.Bridge;
import ro.amiq.vhdldt.parser.VhdlProblem;

public abstract class SyntaxErrorsManagerCommon
implements IVhdlReparseListener {
    public void startup() {
        VhdlModelManager.getInstance().addReparseListener(this);
    }

    public void shutdown() {
        VhdlModelManager.getInstance().removeReparseListener(this);
    }

    public void reparsed(int buildKind, int type, IResource resource, List errors, List warnings, List tasks) {
        if ((type & 2) == 0) {
            return;
        }
        if (resource == null) {
            return;
        }
        if (!resource.isAccessible() || !(resource instanceof IFile)) {
            return;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(resource.getProject(), "F7668646C")) {
            return;
        }
        IFile file = (IFile)resource;
        String filePath = this.getFilePath(file);
        DVTProblemManager.getInstance().removeProblemsWithCategoryAndPath(project, VhdlProblemCategories.VHDL_SYNTAX, filePath);
        if (errors != null && !errors.isEmpty()) {
            for (Object error : errors) {
                DVTProblemManager.getInstance().reportProblem(Bridge.fromError(project, (VhdlProblem)error, filePath, buildKind == 1));
            }
        }
        if (warnings != null && !warnings.isEmpty()) {
            for (Object warning : warnings) {
                DVTProblemManager.getInstance().reportProblem(Bridge.fromWarning(project, (VhdlProblem)warning, filePath, buildKind == 1));
            }
        }
        this.updateProblemsUI((IResource)file, buildKind);
    }

    public abstract void updateProblemsUI(IProject var1, List<VhdlProblem> var2);

    protected abstract void updateProblemsUI(IResource var1, int var2);

    protected abstract String getFilePath(IFile var1);
}

