/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.views.VhdlQuickViewersUtil;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.highlight.VhdlSemanticHighlighter;
import ro.amiq.vhdldt.utils.UtilsCommon;

public class Utils
extends UtilsCommon {
    private static Utils fInstance;

    public static synchronized Utils getInstance() {
        if (fInstance == null) {
            fInstance = new Utils();
        }
        return fInstance;
    }

    public static void connectActiveOpenEditor(RfProject rfProject) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            try {
                if (rfProject.getFileEditors() == null) {
                    return;
                }
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return;
                }
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                if (activePage == null) {
                    return;
                }
                IEditorPart editor = activePage.getActiveEditor();
                if (editor == null) {
                    return;
                }
                if (editor instanceof VhdlEditor) {
                    IFile file = (IFile)editor.getAdapter(IResource.class);
                    if (file == null) {
                        return;
                    }
                    ParserPath parserPath = rfProject.resource2parser((IResource)file);
                    if (parserPath == null) {
                        return;
                    }
                    if (!rfProject.isCompiled(parserPath)) {
                        VhdlQuickViewersUtil.getInstance().scheduleReparseIfNonTop((ITextEditor)((DVTEditor)editor));
                        return;
                    }
                    rfProject.connectFileToDocument(parserPath, (DVTEditor)editor, false);
                    rfProject.notifyParsingEndUsingParserPath(new HashSet<ParserPath>(Arrays.asList(parserPath)));
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public static void refreshMarkers(RfProject rfProject) {
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])new Object[]{rfProject});
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.DifferentColorsDecorator", (Object[])new Object[]{rfProject});
    }

    public static void startHighlight(IRfFileDef fileDef, DVTEditor editor) {
        if (fileDef == null || editor == null) {
            return;
        }
        DVTHlUtils.startHighlight((IRfFileDef)fileDef, (DVTEditor)editor, (DVTSemanticHighlighter)new VhdlSemanticHighlighter(editor.getDocument()), (AbstractUIPlugin)VhdlPlugin.getDefault(), (String)"highlight.semantic");
        ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
    }

    public static void startUpdateBreadcrumbs(DVTEditor editor) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                if (activePage == null) {
                    return;
                }
                Utils.internalSetReadOnlyBreadcrumbs(editor, false);
                if (!activePage.isPartVisible((IWorkbenchPart)editor)) {
                    return;
                }
                ScopeBreadcrumbConfiguration scopeConfig = new ScopeBreadcrumbConfiguration(editor.getCursorScopeForBreadcrumb(true), editor.getCursor(), (IFile)editor.getAdapter(IResource.class), true);
                editor.updateBreadcrumb(ScopeBreadcrumbViewer.class, (AbstractBreadcrumbConfiguration)scopeConfig);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError(e.getMessage());
            }
        });
    }

    public static void setReadOnlyBreadcrumbs() {
        Job updateBCJob = new Job("Setting read-only Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (IEditorReference edReference : ro.amiq.dvt.ui.Utils.getCurrentlyOpenEditorReferences()) {
                    IEditorPart editor = edReference.getEditor(false);
                    if (!(editor instanceof DVTEditor)) continue;
                    Utils.internalSetReadOnlyBreadcrumbs((DVTEditor)editor, true);
                }
                return Status.OK_STATUS;
            }
        };
        updateBCJob.setSystem(true);
        updateBCJob.schedule();
    }

    private static void internalSetReadOnlyBreadcrumbs(DVTEditor editor, boolean isReadOnly) {
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        boolean forceReadOnly = false;
        if (activePage.isPartVisible((IWorkbenchPart)editor)) {
            forceReadOnly = true;
        }
        List breadcrumbViewers = editor.getBreadcrumbViewers();
        for (AbstractBreadcrumbViewer breadcrumb : breadcrumbViewers) {
            if (!(breadcrumb instanceof ThickBreadcrumbViewer) || breadcrumb instanceof DHBreadcrumbViewer && !isReadOnly) continue;
            ((ThickBreadcrumbViewer)breadcrumb).setModelReady(!isReadOnly);
            if (!forceReadOnly && !(breadcrumb instanceof DHBreadcrumbViewer)) continue;
            ((ThickBreadcrumbViewer)breadcrumb).changeReadOnlyState();
        }
    }

    @Override
    public IPath getStateLocation() {
        return VhdlPlugin.getDefault().getStateLocation();
    }

    @Override
    protected void connectPragmaCodePositions(IDocument document, RfFileDef fileDef, Set<DVTSemanticFoldingPosition> foldingPositions) {
        try {
            if (fileDef == null) {
                return;
            }
            RfNamedElement library = fileDef.getEnclosingScope();
            if (library == null) {
                return;
            }
            RfProject rfProject = library.getRfProject();
            if (rfProject == null) {
                return;
            }
            if (document.containsPositionCategory("CUSTOM_PRAGMA")) {
                try {
                    document.removePositionCategory("CUSTOM_PRAGMA");
                    document.removePositionCategory("__dvt_inactive_code_position");
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            document.addPositionCategory("CUSTOM_PRAGMA");
            document.addPositionCategory("__dvt_inactive_code_position");
            if (BuildConfigManager.getCustomPragmas((IProject)rfProject.getProject()).isEmpty()) {
                return;
            }
            List<CustomPragmaUsage> customPragmas = Utils.getCustomPragmas(fileDef.getEnclosingScope().getRfProject(), fileDef.getParserPath());
            if (customPragmas == null) {
                ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"CUSTOM_PRAGMA");
                return;
            }
            ro.amiq.dvt.ui.Utils.addCustomPragmasPositions(customPragmas, foldingPositions, (IDocument)document);
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"CUSTOM_PRAGMA");
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static boolean isContentAssistInsertNamedArguments() {
        return PrefConst.getContentAssistInsertNamedArguments();
    }
}

