/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.IVhdlModel;
import ro.amiq.vhdldt.model.IVhdlProject;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.persistence.Persistence;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.semantic.RfSemanticError;
import ro.amiq.vhdldt.model.reflection.semantic.SemanticErrorsManager;
import ro.amiq.vhdldt.parser.VhdlFileInstance;
import ro.amiq.vhdldt.parser.VhdlFileInstancesMap;

public abstract class UtilsCommon {
    public static String getFileExtension(File file) {
        return Utils.getFileExtension((File)file);
    }

    public static String getFileExtension(String fileName) {
        return Utils.getFileExtension((String)fileName);
    }

    public static String getFileNameNoExtension(File file) {
        return Utils.getFileNameNoExtension((File)file);
    }

    public static String getFileNameNoExtension(String fileName) {
        return Utils.getFileNameNoExtension((String)fileName);
    }

    public static String getFileName(File file) {
        return Utils.getFileName((File)file);
    }

    public static String getFileName(String pathString) {
        return Utils.getFileName((String)pathString);
    }

    public static Object createPosition(int offset, int length) {
        return new DVTPosition(offset, length);
    }

    public static boolean positionDeleted(Object position) {
        return ((Position)position).isDeleted;
    }

    public static int positionLength(Object position) {
        return ((Position)position).length;
    }

    public static int positionOffset(Object position) {
        return ((Position)position).offset;
    }

    public static int documentNumberOfLines(Object document) {
        return ((IDocument)document).getNumberOfLines();
    }

    public static int documentLineOffset(Object document, int line) throws Exception {
        return ((IDocument)document).getLineOffset(line);
    }

    public static void addDocumentPosition(Object document, String category, Object position) throws Exception {
        if (!((IDocument)document).containsPositionCategory(category)) {
            return;
        }
        ((IDocument)document).addPosition(category, (Position)position);
    }

    public static int convertPositionToLine(Object document, int offset) {
        try {
            if (document != null && ((IDocument)document).getLength() > offset) {
                return ((IDocument)document).getLineOfOffset(offset) + 1;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public void connectPositionToDocument(IDocument document, RfFileDef fileDef, Set<DVTSemanticFoldingPosition> foldingPositions, boolean connectOnlyVisualPositions, boolean isEditorVisible, List<Position> reflectionPositions) {
        try {
            if (document == null) {
                return;
            }
            if (!document.containsPositionCategory("REFLECTION")) {
                return;
            }
            if (!connectOnlyVisualPositions) {
                document.removePositionCategory("REFLECTION");
                document.addPositionCategory("REFLECTION");
            }
            UtilsCommon.connectRecursive(fileDef, document, new HashMap<Position, Position>(), connectOnlyVisualPositions, reflectionPositions);
            if (isEditorVisible) {
                this.connectPragmaCodePositions(document, fileDef, foldingPositions);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static List<CustomPragmaUsage> getCustomPragmas(RfProject rfProject, ParserPath parserPath) {
        if (rfProject == null || parserPath == null) {
            return null;
        }
        VhdlFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return null;
        }
        List<VhdlFileInstance> instances = fileInstancesMap.getFileInstances(parserPath);
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        ArrayList<CustomPragmaUsage> result = new ArrayList<CustomPragmaUsage>();
        for (VhdlFileInstance instance : instances) {
            result.addAll(instance.getCustomPragmas());
        }
        return result;
    }

    public static void setCustomPragmas(RfProject rfProject, ParserPath parserPath, List<CustomPragmaUsage> pragmas) {
        if (rfProject == null || parserPath == null) {
            return;
        }
        VhdlFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return;
        }
        List<VhdlFileInstance> instances = fileInstancesMap.getFileInstances(parserPath);
        if (instances == null || instances.isEmpty()) {
            return;
        }
        for (VhdlFileInstance instance : instances) {
            instance.cleanCustomPragmas();
        }
        instances.get(0).setCustomPragmas(pragmas);
    }

    private static void connectRecursive(RfDefElement root, IDocument document, Map<Position, Position> cachedPositions, boolean connectPositionsAfterEditorFocus, List<Position> reflectionPositions) {
        Collection<RfDefElement> children = root.getChildren();
        if (children == null) {
            return;
        }
        for (RfDefElement child : children) {
            if (!connectPositionsAfterEditorFocus) {
                child.connectPositionToDocument(document, cachedPositions, reflectionPositions);
            }
            if (child.getChildren() == children) continue;
            UtilsCommon.connectRecursive(child, document, cachedPositions, connectPositionsAfterEditorFocus, reflectionPositions);
        }
    }

    public static void disconnectPositionToDocument(Object document, RfFileDef fileDef) {
        try {
            if (!(document instanceof IDocument)) {
                return;
            }
            IDocument iDocument = (IDocument)document;
            if (!iDocument.containsPositionCategory("REFLECTION")) {
                return;
            }
            boolean isCloned = DVTUtilsCommon.INSTANCE.isOpenClonedEditorSharingSameDocument(iDocument);
            if (isCloned) {
                return;
            }
            iDocument.removePositionCategory("REFLECTION");
            iDocument.addPositionCategory("REFLECTION");
            fileDef.removePosition();
            UtilsCommon.disconnectRecursive(fileDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static void disconnectRecursive(RfDefElement root) {
        Collection<RfDefElement> cildren = root.getChildren();
        if (cildren == null) {
            return;
        }
        for (RfDefElement child : cildren) {
            child.removePosition();
            if (child.getChildren() == cildren) continue;
            UtilsCommon.disconnectRecursive(child);
        }
    }

    public static IResource getFileAdapter(RfProject rfProject, String fullPath) {
        return DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(rfProject.getProject(), fullPath);
    }

    public static String getCrossPlatformPath(String inputPath) {
        return DVTUtilsCommon.INSTANCE.getCrossPlatformPath(inputPath);
    }

    public static void saveRFDM(RfProject rfProject, boolean incremental, boolean async, boolean reportSavingProject) {
        Persistence persistence = RfManager.getInstance().getPersistence(rfProject.getProject());
        if (persistence == null) {
            return;
        }
        persistence.save(rfProject, incremental, async, reportSavingProject, BuildConfigManagerCommon.PersistenceModeWrapper.regular());
    }

    public static void cleanSemanticMarkers(IProject project) {
        SemanticErrorsManager.getInstance().clean(project);
    }

    public static void triggerSemanticMarkers(RfProject rfProject, List<RfSemanticError> semanticErrors, boolean toConsole) {
        SemanticErrorsManager.getInstance().reparsed(rfProject.getProject(), semanticErrors, toConsole);
    }

    public static void runOnDisplayThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    public static int getEndOffset(Object position) {
        if (position != null) {
            return ((Position)position).getOffset() + ((Position)position).getLength();
        }
        return 0;
    }

    public static int getStartOffset(Object position) {
        if (position != null) {
            return ((Position)position).getOffset();
        }
        return 0;
    }

    public static int convertLineToOffset(Object document, int line) {
        block3: {
            try {
                if (document != null) break block3;
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return ((IDocument)document).getLineOffset(line - 1);
    }

    public static RfProject getRfProject(IProject project) {
        return RfManager.getInstance().getRfProject(project);
    }

    public static int maxIssuesKindNumber(IProject project) {
        int maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)project);
        return maxIssuesKindNumber;
    }

    public static IVhdlProject getVhdlProject(IProject project) {
        IVhdlModel vhdlModel = VhdlModelManager.getInstance().getVhdlModel();
        IVhdlProject vhdlProject = vhdlModel.getVhdlProject(project);
        return vhdlProject;
    }

    public static int documentLength(IDocument document) {
        return document.getLength();
    }

    public static int getCodeFoldingNofLines() {
        return VhdlPlugin.getDefault().getPreferenceStore().getInt("editor.numberOfLines");
    }

    public abstract IPath getStateLocation();

    protected abstract void connectPragmaCodePositions(IDocument var1, RfFileDef var2, Set<DVTSemanticFoldingPosition> var3);
}

