/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.comment.formatter.CommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDuplicate;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;

public class VHDLLinkResolver
extends CommentLinkResolver {
    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    public Collection<IRfNamedElement> getInitialCandidates(IRfNamedElement element, ITextEditor textEditor) {
        IRfScopeElement scope = element.getEnclosingScope();
        if (scope == null) {
            return null;
        }
        return VHDLLinkResolver.getInitialCandidatesInScope(scope);
    }

    public IRfNamedElement solveHyperlinkForAllCandidates(IRfNamedElement element, Collection<IRfNamedElement> candidates, String[] parsedLink, long timeoutTime) {
        try {
            for (IRfNamedElement candidate : candidates) {
                IRfNamedElement foundElement = this.recursiveFindElement(candidate, parsedLink, 0, timeoutTime);
                if (foundElement == null) continue;
                return foundElement;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static Collection<IRfNamedElement> getInitialCandidatesInScope(IRfScopeElement scope) {
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        while (scope != null) {
            if (scope instanceof RfNamedElement) {
                result.add((RfNamedElement)scope);
            }
            scope = scope.getEnclosingScope();
        }
        return result;
    }

    public static List<RfNamedElement> getCandidatesInScope(IRfNamedElement element) {
        Collection<RfNamedElement> tempMembers;
        if (element instanceof RfAlias) {
            element = ((RfAlias)element).getTranslatedType();
        }
        if ((tempMembers = ((RfNamedElement)element).getMembers()) == null) {
            return null;
        }
        LinkedList<RfNamedElement> membersQueue = new LinkedList<RfNamedElement>(tempMembers);
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        while (!membersQueue.isEmpty()) {
            RfNamedElement member = (RfNamedElement)membersQueue.poll();
            if (member instanceof RfDuplicate) {
                membersQueue.addAll(VHDLLinkResolver.getElementsFromDuplicate((RfDuplicate)member));
                continue;
            }
            RfNamedElement enclosingScope = member.getEnclosingScope();
            if (!VHDLLinkResolver.isType(member) && !VHDLLinkResolver.isType(enclosingScope)) continue;
            if (member instanceof RfFunctionsHolder) {
                Collection<RfNamedElement> functions = member.getMembers();
                if (functions == null) continue;
                Iterator<RfNamedElement> it = functions.iterator();
                while (it.hasNext()) {
                    result.add(it.next());
                }
                continue;
            }
            result.add(member);
        }
        return result;
    }

    private static Collection<RfNamedElement> getElementsFromDuplicate(RfDuplicate member) {
        Collection<RfNamedElement> functions = member.getMembers();
        if (functions == null) {
            return new ArrayList<RfNamedElement>();
        }
        return functions;
    }

    private static boolean isType(RfNamedElement element) {
        return element instanceof IRfTypeElement || element instanceof IRfDesignElement || element instanceof IRfPackageElement || element instanceof IRfBlockElement;
    }

    public IRfNamedElement recursiveFindElement(IRfNamedElement scope, String[] parsedElementPath, int pathIndex, long timeoutTime) throws Exception {
        if (System.currentTimeMillis() > timeoutTime) {
            throw new Exception("Tooltip timeout in resolving link " + String.join((CharSequence)".", parsedElementPath));
        }
        if (!(scope instanceof RfNamedElement) || parsedElementPath == null) {
            return null;
        }
        RfNamedElement element = (RfNamedElement)scope;
        if (element instanceof RfAlias) {
            ((RfAlias)element).getDeclarations();
        }
        if (pathIndex >= parsedElementPath.length) {
            return scope;
        }
        List<RfNamedElement> members = VHDLLinkResolver.getCandidatesInScope(element);
        if (members == null) {
            return null;
        }
        String name = VHDLLinkResolver.extractName(parsedElementPath[pathIndex]);
        String[] args = VHDLLinkResolver.extractArgs(parsedElementPath[pathIndex]);
        IRfNamedElement result = null;
        for (RfNamedElement member : members) {
            if (!parsedElementPath[pathIndex].equals(member.getName()) && !VHDLLinkResolver.isElementWithGenericParams(member, parsedElementPath[pathIndex], args, name)) continue;
            result = this.recursiveFindElement(member, parsedElementPath, pathIndex + 1, timeoutTime);
        }
        if (result != null) {
            return result;
        }
        return null;
    }

    public static boolean isElementWithGenericParams(RfNamedElement member, String originalElementPathName, String[] args, String name) {
        if (!(member instanceof RfFunction) || !((RfFunction)member).hasArguments()) {
            return false;
        }
        String signatureWithoutType = ((RfFunction)member).getSignatureWithoutType(true);
        if (signatureWithoutType != null && originalElementPathName.equals(VHDLLinkResolver.removeWhitespaces(signatureWithoutType))) {
            return true;
        }
        if (name == null || !member.getName().equals(name)) {
            return false;
        }
        Object[] allArgsByName = ((RfFunction)member).getAllArgsByName();
        if (allArgsByName == null || allArgsByName.length == 0) {
            return false;
        }
        Object allArgs = allArgsByName[0];
        if (!(allArgs instanceof LinkedHashMap)) {
            return false;
        }
        if (args == null || args.length != ((LinkedHashMap)allArgs).size()) {
            return false;
        }
        int argsIndex = 0;
        for (Map.Entry argument : ((LinkedHashMap)allArgs).entrySet()) {
            if (!args[argsIndex].equals(argument.getKey()) && !args[argsIndex].equalsIgnoreCase(VHDLLinkResolver.extractArgument(argument.getValue()))) {
                return false;
            }
            ++argsIndex;
        }
        return true;
    }

    private static String removeWhitespaces(String name) {
        return name.replace(" ", "");
    }

    private static String extractArgument(Object obj) {
        if (obj instanceof RfVariable) {
            IRfNamedElement associatedType = ((RfVariable)obj).getAssociatedType();
            if (associatedType == null) {
                return "";
            }
            return associatedType.getName();
        }
        return "";
    }

    public static String extractName(String nameWithParams) {
        if (nameWithParams == null || nameWithParams.isEmpty() || !nameWithParams.contains("(")) {
            return null;
        }
        int indexEnd = nameWithParams.indexOf("(");
        String name = nameWithParams.substring(0, indexEnd);
        if (name == null) {
            return null;
        }
        return name.trim();
    }

    public static String[] extractArgs(String name) {
        if (name == null || name.isEmpty() || !name.contains("(")) {
            return null;
        }
        int indexStart = name.indexOf("(") + "(".length();
        if (indexStart < 0 || indexStart > name.length()) {
            return null;
        }
        int indexEnd = name.indexOf(")");
        if (indexEnd < 0 || indexEnd > name.length() || indexStart > indexEnd) {
            return null;
        }
        String declaredTypes = name.substring(indexStart, indexEnd);
        String[] types = DVTStringUtil.split((Pattern)CommentConstants.ARGS_PATTERN, (String)declaredTypes);
        return types;
    }

    public IFile getIFileFromElement(IRfNamedElement element) {
        if (element == null || !(element instanceof RfNamedElement)) {
            return null;
        }
        RfDefElement defElem = ((RfNamedElement)element).getDeclaration();
        if (defElem == null) {
            return null;
        }
        RfFileDef defFile = defElem.getDefFile();
        if (defFile == null) {
            return null;
        }
        Object fileObj = defFile.getAdapter(IResource.class);
        if (!(fileObj instanceof IFile)) {
            return null;
        }
        return (IFile)fileObj;
    }

    public IRfNamedElement getNamedElementFromPath(String path, IProject project) {
        RfElementPath elementPath = RfElementPath.fromString((String)path, VHDLLinkResolver.class);
        if (elementPath == null) {
            return null;
        }
        return elementPath.toNamedElement(project);
    }

    public List<IRfNamedElement> getPackageCandidates(String packageName, IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        return VHDLLinkResolver.getPackageCandidatesFromProject(packageName, rfProject);
    }

    public static List<IRfNamedElement> getPackageCandidatesFromProject(String packageName, RfProject rfProject) {
        if (rfProject == null) {
            return null;
        }
        List<RfNamedElement> packages = rfProject.getAllPackages();
        if (packages == null) {
            return null;
        }
        Iterator it = packages.iterator();
        ArrayList<IRfNamedElement> packageCandidates = new ArrayList<IRfNamedElement>();
        while (it.hasNext()) {
            RfNamedElement currPackage = (RfNamedElement)it.next();
            if (!packageName.equalsIgnoreCase(currPackage.getName())) continue;
            packageCandidates.add(currPackage);
        }
        return packageCandidates;
    }

    public IFile getFile(IRfNamedElement element, IProject project) {
        return this.getIFileFromElement(element);
    }
}

