/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.vhdldt.ui.VhdlFileLabelProvider;
import ro.amiq.vhdldt.utils.VhdlFileUtilsCommon;

public class VhdlFileUtils
extends VhdlFileUtilsCommon {
    protected VhdlFileUtils() {
    }

    public IFile selectFile(final IFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        final IFile[] result = new IFile[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new VhdlFileLabelProvider2());
                dialog.setElements((Object[])files);
                dialog.setTitle("Select Workspace File");
                dialog.setMessage("The selected file is referenced by multiple linked resources in the workspace.\nSelect a workspace resource to open the file.");
                if (dialog.open() == 0) {
                    result[0] = (IFile)dialog.getFirstResult();
                }
            }
        });
        return result[0];
    }

    public IProject selectProject(IProject[] projects, String message, IProject defaultSelection) {
        return Utils.selectProject((IProject[])projects, (String)message, (ILabelProvider)new VhdlFileLabelProvider2(), (IProject)defaultSelection);
    }

    static class VhdlFileLabelProvider2
    extends VhdlFileLabelProvider {
        VhdlFileLabelProvider2() {
        }

        @Override
        protected String decorateText(String input, Object element) {
            if (element instanceof IFile) {
                return ((IFile)element).getFullPath().toOSString();
            }
            if (element instanceof IFolder) {
                return ((IFolder)element).getProjectRelativePath().toOSString();
            }
            return input;
        }
    }
}

