/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.utils;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vhdldt.ui.editor.VhdlFileEditorInput;
import ro.amiq.vhdldt.utils.VhdlFileUtils;

public class VhdlFileUtilsCommon
extends DVTFileUtils {
    private static volatile VhdlFileUtils fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VhdlFileUtils getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VhdlFileUtils();
            }
        }
        return fInstance;
    }

    public void openEditor(File file, int line, String selectIdentifier) {
        try {
            if (file.exists()) {
                VhdlFileEditorInput editorInput = new VhdlFileEditorInput(file);
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)editorInput, (String)"ro.amiq.vhdldt.ui.editor.VhdlEditor");
                this.selectAndReveal(line, selectIdentifier, editorPart);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void internalOpenEditor(IProject project, File classicFile, int line, String selectIdentifier) {
        IFile candidate = this.getProjectFile(project, classicFile.getAbsolutePath());
        if (candidate == null) {
            this.openEditor(classicFile, line, selectIdentifier);
            return;
        }
        this.openEditor(candidate, line, selectIdentifier);
    }

    public void openFile(IProject project, String knownPath, int line, String selectIdentifier) {
        String customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        IFile candidate = this.findProjectFile(project, knownPath);
        if (candidate != null) {
            this.openEditor(candidate, line, selectIdentifier);
            return;
        }
        Path path = new Path(Utils.canonicPath((String)knownPath));
        File classicFile = path.toFile();
        if (path.isAbsolute()) {
            this.internalOpenEditor(project, classicFile, line, selectIdentifier);
            return;
        }
        classicFile = new File(customPath);
        this.internalOpenEditor(project, classicFile, line, selectIdentifier);
    }
}

