/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.settings;

import java.io.File;
import java.util.ArrayList;

public class DVTSConstants {
    public static final String DVT_SETTINGS_PROJECT_NAME = "DVT-Settings";
    public static final String DVT_FOLDER_PREFIX_COMMON = "common";
    public static final String DVT_FOLDER_PREFIX_USER = "user";
    public static final String MANAGED_SETTINGS_PATH = "ro.amiq.dvt.startup";
    public static final String MANAGED_SETTINGS_KEY = "managedSettings";
    public static final String MANAGED_SETTINGS_FULLKEY = "ro.amiq.dvt.startup/managedSettings";
    public static final String PREFERENCES_COMMAND_ID = "org.eclipse.ui.window.preferences";
    public static final String DVT_COMMON_SETTINGS_ENV = "DVT_COMMON_SETTINGS";
    private static final String DVT_COMMON_SETTINGS_PROP = "ro.amiq.dvt.commonSettings";
    public static final String DVT_USER_SETTINGS_ENV = "DVT_USER_SETTINGS";
    private static final String DVT_USER_SETTINGS_PROP = "ro.amiq.dvt.userSettings";
    public static final boolean MANAGE_SETTINGS;
    public static final String DVT_USER_SETTINGS;
    public static final String[] DVT_COMMON_SETTINGS;

    static {
        String dvtUserSettings = DVTSConstants.getEnvironmentOrProperty(DVT_USER_SETTINGS_ENV, DVT_USER_SETTINGS_PROP);
        String[] dvtCommonSettings = DVTSConstants.splitPaths(DVTSConstants.getEnvironmentOrProperty(DVT_COMMON_SETTINGS_ENV, DVT_COMMON_SETTINGS_PROP));
        if (dvtUserSettings != null && dvtUserSettings.equalsIgnoreCase("disabled")) {
            dvtUserSettings = null;
            dvtCommonSettings = null;
        }
        boolean bl = MANAGE_SETTINGS = dvtCommonSettings != null || dvtUserSettings != null;
        if (MANAGE_SETTINGS && dvtUserSettings == null) {
            String userHome = System.getProperty("user.home");
            if (userHome == null) {
                userHome = new File(".").getAbsolutePath();
            }
            dvtUserSettings = new File(userHome, ".dvt/settings").getAbsolutePath();
        }
        DVT_USER_SETTINGS = dvtUserSettings;
        DVT_COMMON_SETTINGS = dvtCommonSettings;
    }

    private static String getEnvironmentOrProperty(String env, String prop) {
        String envVar = System.getenv(env);
        String propVar = System.getProperty(prop);
        return envVar != null ? envVar : propVar;
    }

    private static String[] splitPaths(String paths) {
        String[] pathsSplit;
        if (paths == null) {
            return null;
        }
        ArrayList<String> pathsArray = new ArrayList<String>();
        String[] stringArray = pathsSplit = paths.split(File.pathSeparator);
        int n = pathsSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSplit = stringArray[n2];
            if (!pathSplit.trim().isEmpty()) {
                pathsArray.add(pathSplit);
            }
            ++n2;
        }
        if (pathsArray.isEmpty()) {
            return null;
        }
        return pathsArray.toArray(new String[pathsArray.size()]);
    }
}

