/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.settings.DVTSConstants;

public enum DVTSFiles {
    EXPORT_HTML_DVT("specador_preferences.xml"),
    EXTERNAL_BUILDERS("external_builders.xml"),
    GUI_FILTERS("content_filters.xml"),
    GTKRC("theme.gtkrc"),
    PREFERENCES("preferences.ini"),
    WAIVERS("waivers.xml"),
    PROJECT_EXPLORER_NODES("project_explorer_nodes.xml"),
    CHD("chd.ini"),
    LOG_STYLES("log_styles.xml"),
    NAME_CHECK("naming_conventions.xml"),
    CUSTOM_PRAGMAS("custom_pragmas.xml"),
    DVT_PRE_TCL_INTERPRET_FILE("dvt_pre_interpret.tcl"),
    DVT_POST_TCL_INTERPRET_FILE("dvt_post_interpret.tcl");

    private final String fFileName;

    private DVTSFiles(String fileName) {
        this.fFileName = fileName;
    }

    public String getName() {
        return this.fFileName;
    }

    public File getUserFile(boolean onlyExisting) {
        if (!DVTSConstants.MANAGE_SETTINGS || DVTSConstants.DVT_USER_SETTINGS == null) {
            return null;
        }
        File file = new File(DVTSConstants.DVT_USER_SETTINGS, this.fFileName);
        return onlyExisting && !file.canRead() ? null : file;
    }

    public List<File> getCommonFiles(boolean onlyExisting) {
        if (!DVTSConstants.MANAGE_SETTINGS || DVTSConstants.DVT_COMMON_SETTINGS == null) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        String[] stringArray = DVTSConstants.DVT_COMMON_SETTINGS;
        int n = DVTSConstants.DVT_COMMON_SETTINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String commonDirectory = stringArray[n2];
            File file = new File(commonDirectory, this.fFileName);
            if (!onlyExisting || file.canRead()) {
                result.add(file);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<File> getAllFiles(boolean onlyExisting) {
        File userFile;
        if (!DVTSConstants.MANAGE_SETTINGS) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        List<File> commonFiles = this.getCommonFiles(onlyExisting);
        if (commonFiles != null) {
            result.addAll(commonFiles);
        }
        if ((userFile = this.getUserFile(onlyExisting)) != null) {
            result.add(userFile);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

