/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.settings;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import ro.amiq.dvt.settings.DVTSConstants;

public class DVTSManagedCommonTab
extends CommonTab {
    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        DVTSManagedCommonTab.setAsShared(config);
    }

    public static void refreshSettingsDirectory() throws CoreException {
        if (DVTSConstants.MANAGE_SETTINGS) {
            return;
        }
        IFolder container = ResourcesPlugin.getWorkspace().getRoot().getProject("DVT-Settings").getFolder("user");
        if (!container.isAccessible()) {
            return;
        }
        container.refreshLocal(1, null);
    }

    public static void setAsShared(ILaunchConfigurationWorkingCopy config) {
        IFolder container;
        if (DVTSConstants.MANAGE_SETTINGS && (container = ResourcesPlugin.getWorkspace().getRoot().getProject("DVT-Settings").getFolder("user")).isAccessible()) {
            config.setContainer((IContainer)container);
            try {
                ArrayList<String> favoriteGroups = new ArrayList<String>();
                if (!config.getAttribute("org.eclipse.debug.ui.private", false)) {
                    ILaunchGroup[] groups;
                    ILaunchGroup[] iLaunchGroupArray = groups = DebugUITools.getLaunchGroups();
                    int n = groups.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchGroup group = iLaunchGroupArray[n2];
                        if (config.getType().supportsMode(group.getMode())) {
                            String configCategory = config.getCategory();
                            String groupCategory = group.getCategory();
                            if (configCategory == null && groupCategory == null || configCategory != null && groupCategory != null && groupCategory.equals(configCategory)) {
                                favoriteGroups.add(group.getIdentifier());
                            }
                        }
                        ++n2;
                    }
                }
                config.setAttribute("org.eclipse.debug.ui.favoriteGroups", favoriteGroups);
            }
            catch (CoreException coreException) {}
        }
    }
}

