/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import ro.amiq.dvt.settings.DVTSConstants;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.settings.DVTSPreferencesMerger;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupPlugin;

public enum DVTSPreferencesManager {
    INSTANCE;

    private static final long MAX_PREFERENCES_SIZE = 0x2000000L;
    private static final HashSet<String> EXCLUDED_PREFERENCES;
    private static final String VIPLUGIN_PREFERENCES_PREFIX = "com.mbartl.eclipse.viplugin/";
    private static final HashSet<String> VIPLUGIN_SPECIAL_CHAR_SEPARATOR_PREFERENCES;
    private static final String VIPLUGIN_SPECIAL_CHAR_SEPARATOR = "\ufffd\ufffd";
    private static final String VIPLUGIN_SERIALIZED_MACRO_PREFERENCES = "com.mbartl.eclipse.viplugin/MACRO_";
    private static final String VIPLUGIN_SERIALIZED_MACRO_TEXT_1 = "com.mbartl.viplugineclipse.viimplementation.util.Macro";
    private static final String VIPLUGIN_SERIALIZED_MACRO_TEXT_2 = "com.mbartl.viplugineclipse.viimplementation.util.ViKeyEvent";
    private static final String VIPLUGIN_SERIALIZED_REGISTER_PREFERENCES = "com.mbartl.eclipse.viplugin/REGISTER_";
    private static final String VIPLUGIN_SERIALIZED_REGISTER_TEXT = "com.mbartl.viplugineclipse.viimplementation.registers.TextBuffer";
    private static final Pattern TREE_FILES;
    private final Properties fCommonPreferences = new Properties();
    private final Properties fUserPreferences = new Properties();

    static {
        TREE_FILES = Pattern.compile("\\d+\\.tree");
        EXCLUDED_PREFERENCES = new HashSet();
        EXCLUDED_PREFERENCES.add("ro.amiq.dvt.startup/managedSettings");
        EXCLUDED_PREFERENCES.add("org.eclipse.core.resources/version");
        EXCLUDED_PREFERENCES.add("org.eclipse.ui.ide/platformState");
        EXCLUDED_PREFERENCES.add("org.eclipse.ui.ide/tipsAndTricks");
        EXCLUDED_PREFERENCES.add("org.eclipse.ui.ide/quickStart");
        EXCLUDED_PREFERENCES.add("org.eclipse.ui.ide/TASKS_FILTERS_MIGRATE");
        EXCLUDED_PREFERENCES.add("org.eclipse.ui.ide/PROBLEMS_FILTERS_MIGRATE");
        EXCLUDED_PREFERENCES.add("org.eclipse.ui.ide/tipsAndTricks");
        EXCLUDED_PREFERENCES.add("org.eclipse.ui.editors/overviewRuler_migration");
        EXCLUDED_PREFERENCES.add("org.eclipse.ui/showIntro");
        EXCLUDED_PREFERENCES.add("org.eclipse.core.net/org.eclipse.core.net.hasMigrated");
        EXCLUDED_PREFERENCES.add("org.eclipse.ui.workbench//org.eclipse.ui.commands/state/org.eclipse.ui.navigator.resources.nested.changeProjectPresentation/org.eclipse.ui.commands.radioState");
        VIPLUGIN_SPECIAL_CHAR_SEPARATOR_PREFERENCES = new HashSet();
        VIPLUGIN_SPECIAL_CHAR_SEPARATOR_PREFERENCES.add("com.mbartl.eclipse.viplugin/abbreviations");
        VIPLUGIN_SPECIAL_CHAR_SEPARATOR_PREFERENCES.add("com.mbartl.eclipse.viplugin/imap");
        VIPLUGIN_SPECIAL_CHAR_SEPARATOR_PREFERENCES.add("com.mbartl.eclipse.viplugin/map");
    }

    public void init() {
        if (DVTSConstants.MANAGE_SETTINGS) {
            if (!this.createPreferencesFile(DVTSFiles.PREFERENCES.getUserFile(false))) {
                return;
            }
            this.loadPreferences();
            this.initPreferences();
            this.addListeners();
        }
    }

    private void loadPreferences() {
        this.loadCommonPreferences();
        this.loadUserPreferences();
    }

    private void initPreferences() {
        try {
            final boolean hasManagedSettings = DVTStartupPlugin.getDefault().getStateLocation().append("DVT-Settings").toFile().exists();
            Job job = new Job("Restoring preferences"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (DVTSPreferencesManager.this.isNewWorkspace()) {
                        DVTSPreferencesManager.this.restoreManagedPreferences();
                    } else if (hasManagedSettings) {
                        DVTSPreferencesManager.this.restoreManagedPreferences();
                    } else {
                        DVTSPreferencesManager.this.restoreUnmanagedPreferences();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private void addListeners() {
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public void postShutdown(IWorkbench workbench) {
                DVTSPreferencesManager.this.savePreferences();
            }

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                return true;
            }
        });
    }

    public Properties getUnsavedPreferences() {
        return this.filterAndCopyPreferences(this.unmergePreferences(this.unmergePreferences(this.getInstancePreferences(), this.fCommonPreferences, this.fUserPreferences, true), this.fUserPreferences, null, false));
    }

    public boolean isNewWorkspace() {
        File root = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata/.plugins/org.eclipse.core.resources/.root").toFile();
        File[] treeFiles = root.listFiles(file -> file.getName().endsWith(".tree") && TREE_FILES.matcher(file.getName()).matches() && file.isFile());
        return treeFiles == null || treeFiles.length == 0;
    }

    private void restoreManagedPreferences() {
        Properties instancePreferences = this.getInstancePreferences();
        Properties excludedPreferences = this.separateExcludedPreferences(instancePreferences);
        this.setInstancePreferences(this.mergePreferences(this.mergePreferences(this.fCommonPreferences, this.fUserPreferences), excludedPreferences));
    }

    private void restoreUnmanagedPreferences() {
        Properties instancePreferences = this.getInstancePreferences();
        Properties excludedPreferences = this.separateExcludedPreferences(instancePreferences);
        Properties instanceUserPreferences = this.unmergePreferences(instancePreferences, this.fCommonPreferences, this.fUserPreferences, true);
        this.filterAndCopyPreferences(this.fUserPreferences, instanceUserPreferences);
        this.writeToUserPreferencesFile(this.fUserPreferences);
        this.setInstancePreferences(this.mergePreferences(this.mergePreferences(this.fCommonPreferences, this.fUserPreferences), excludedPreferences));
    }

    public void savePreferences() {
        Properties instancePreferences = this.getInstancePreferences();
        Properties excludedPreferences = this.separateExcludedPreferences(instancePreferences);
        Properties instanceUserPreferences = this.unmergePreferences(instancePreferences, this.fCommonPreferences, this.fUserPreferences, true);
        Properties fileUserPreferences = this.filterAndCopyPreferences(this.readFromUserPreferencesFile());
        if (!this.equalPreferences(this.fUserPreferences, fileUserPreferences)) {
            Properties newUserPreferences = this.unmergePreferences(instanceUserPreferences, this.fUserPreferences, null, false);
            this.filterAndCopyPreferences(instanceUserPreferences, this.mergePreferences(fileUserPreferences, newUserPreferences));
            this.setInstancePreferences(this.mergePreferences(instanceUserPreferences, excludedPreferences));
        }
        this.filterAndCopyPreferences(this.fUserPreferences, instanceUserPreferences);
        this.writeToUserPreferencesFile(instanceUserPreferences);
    }

    private boolean equalPreferences(Properties props1, Properties props2) {
        if (props1 == props2) {
            return true;
        }
        if (props1 == null || props2 == null) {
            return false;
        }
        if (props1.size() != props2.size()) {
            return false;
        }
        for (Object okey : props1.keySet()) {
            String key = (String)okey;
            if (DVTSPreferencesMerger.equals(key, props1.getProperty(key), props2.getProperty(key))) continue;
            return false;
        }
        return true;
    }

    private Properties mergePreferences(Properties commonProps, Properties userProps) {
        Properties mergedProps = new Properties();
        if (commonProps == null || commonProps.isEmpty()) {
            mergedProps.putAll((Map<?, ?>)userProps);
            return mergedProps;
        }
        if (userProps == null || userProps.isEmpty()) {
            mergedProps.putAll((Map<?, ?>)commonProps);
            return mergedProps;
        }
        HashSet<Object> allKeys = new HashSet<Object>();
        allKeys.addAll(commonProps.keySet());
        allKeys.addAll(userProps.keySet());
        for (Object e : allKeys) {
            String key = (String)e;
            mergedProps.setProperty(key, DVTSPreferencesMerger.merge(key, commonProps.getProperty(key), userProps.getProperty(key)));
        }
        return mergedProps;
    }

    private Properties unmergePreferences(Properties instanceProps, Properties commonProps, Properties userProps, boolean useDefaults) {
        HashSet<Object> allKeys = new HashSet<Object>();
        if (instanceProps != null) {
            allKeys.addAll(instanceProps.keySet());
        }
        if (commonProps != null) {
            allKeys.addAll(commonProps.keySet());
        }
        if (userProps != null) {
            allKeys.addAll(userProps.keySet());
        }
        Properties unmergedProps = new Properties();
        for (Object e : allKeys) {
            String userValue;
            String commonValue;
            String instanceValue;
            String value;
            String key = (String)e;
            String defaultValue = null;
            if (useDefaults) {
                defaultValue = this.getDefaultScopeValue(key);
            }
            if ((value = DVTSPreferencesMerger.unmerge(key, instanceValue = instanceProps == null ? null : instanceProps.getProperty(key), defaultValue, commonValue = commonProps == null ? null : commonProps.getProperty(key), userValue = userProps == null ? null : userProps.getProperty(key))) == null) continue;
            unmergedProps.setProperty(key, value);
        }
        return unmergedProps;
    }

    private IEclipsePreferences getInstanceNode() {
        return this.getScopeNode("instance");
    }

    private IEclipsePreferences getDefaultNode() {
        return this.getScopeNode("default");
    }

    private IEclipsePreferences getScopeNode(String scope) {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences instancePreferences = root.node(scope);
        if (instancePreferences instanceof IEclipsePreferences) {
            return (IEclipsePreferences)instancePreferences;
        }
        return null;
    }

    private Properties getScopePreferences(IEclipsePreferences scope) {
        Properties result = new Properties();
        if (scope == null) {
            return result;
        }
        try {
            scope.accept(node -> {
                String[] keys;
                String absolutePath = node.absolutePath();
                if (absolutePath.startsWith(String.valueOf('/') + scope.name() + '/')) {
                    absolutePath = absolutePath.substring(scope.name().length() + 2);
                }
                String[] stringArray = keys = node.keys();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    String value = node.get(key, null);
                    if (value != null) {
                        String fullKey = EclipsePreferences.encodePath((String)absolutePath, (String)key);
                        result.setProperty(fullKey, value);
                    }
                    ++n2;
                }
                return true;
            });
        }
        catch (BackingStoreException backingStoreException) {}
        return result;
    }

    private Properties getInstancePreferences() {
        return this.getScopePreferences(this.getInstanceNode());
    }

    private void setInstancePreferences(Properties preferences) {
        Display.getDefault().syncExec(() -> {
            IEclipsePreferences instanceNode = this.getInstanceNode();
            try {
                instanceNode.accept(node -> {
                    try {
                        node.clear();
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError(e);
                    }
                    return true;
                });
            }
            catch (Exception exception) {}
            for (Map.Entry<Object, Object> entry : preferences.entrySet()) {
                String[] splitPath;
                String value = (String)entry.getValue();
                if (value == null || (splitPath = EclipsePreferences.decodePath((String)((String)entry.getKey())))[0] == null || splitPath[1] == null) continue;
                instanceNode.node(splitPath[0]).put(splitPath[1], value);
            }
            try {
                instanceNode.flush();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError(e);
            }
        });
    }

    private String getDefaultScopeValue(String key) {
        String[] splitPath = EclipsePreferences.decodePath((String)key);
        if (splitPath[0] == null || splitPath[1] == null) {
            return null;
        }
        IEclipsePreferences defaultNode = this.getDefaultNode();
        if (defaultNode == null) {
            return null;
        }
        return defaultNode.node(splitPath[0]).get(splitPath[1], null);
    }

    private Properties separateExcludedPreferences(Properties preferences) {
        Properties result = new Properties();
        Iterator<Map.Entry<Object, Object>> iterator = preferences.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String fullKey = (String)entry.getKey();
            if (!EXCLUDED_PREFERENCES.contains(fullKey)) continue;
            result.setProperty(fullKey, (String)entry.getValue());
            iterator.remove();
        }
        return result;
    }

    private Properties filterAndCopyPreferences(Properties sourcePreferences) {
        Properties destinationPreferences = new Properties();
        this.filterAndCopyPreferences(destinationPreferences, sourcePreferences);
        return destinationPreferences;
    }

    private void filterAndCopyPreferences(Properties destinationPreferences, Properties sourcePreferences) {
        destinationPreferences.clear();
        for (Map.Entry<Object, Object> preference : sourcePreferences.entrySet()) {
            String fullKey = (String)preference.getKey();
            if (fullKey == null || EXCLUDED_PREFERENCES.contains(fullKey)) continue;
            String value = (String)preference.getValue();
            if (fullKey.contains(VIPLUGIN_SERIALIZED_MACRO_TEXT_1) || fullKey.contains(VIPLUGIN_SERIALIZED_MACRO_TEXT_2) || fullKey.contains(VIPLUGIN_SERIALIZED_REGISTER_TEXT) || fullKey.startsWith(VIPLUGIN_PREFERENCES_PREFIX) && value != null && !value.isEmpty() && (fullKey.startsWith(VIPLUGIN_SERIALIZED_MACRO_PREFERENCES) && (value.contains(VIPLUGIN_SERIALIZED_MACRO_TEXT_1) || value.contains(VIPLUGIN_SERIALIZED_MACRO_TEXT_2)) || fullKey.startsWith(VIPLUGIN_SERIALIZED_REGISTER_PREFERENCES) && value.contains(VIPLUGIN_SERIALIZED_REGISTER_TEXT) || VIPLUGIN_SPECIAL_CHAR_SEPARATOR_PREFERENCES.contains(fullKey) && !value.endsWith(VIPLUGIN_SPECIAL_CHAR_SEPARATOR))) continue;
            destinationPreferences.setProperty(fullKey, (String)preference.getValue());
        }
    }

    private void loadCommonPreferences() {
        this.filterAndCopyPreferences(this.fCommonPreferences, this.readFromCommonPreferencesFile());
    }

    private void loadUserPreferences() {
        this.filterAndCopyPreferences(this.fUserPreferences, this.readFromUserPreferencesFile());
    }

    private Properties readFromUserPreferencesFile() {
        return this.readPreferencesFromFile(DVTSFiles.PREFERENCES.getUserFile(true));
    }

    private Properties readFromCommonPreferencesFile() {
        return this.readPreferencesFromFiles(DVTSFiles.PREFERENCES.getCommonFiles(true));
    }

    private void writeToUserPreferencesFile(Properties preferences) {
        this.writePreferencesToFile(preferences, DVTSFiles.PREFERENCES.getUserFile(false));
    }

    private Properties readPreferencesFromFiles(List<File> files) {
        Properties result = new Properties();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            result = this.mergePreferences(result, this.readPreferencesFromFile(file));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties readPreferencesFromFile(File file) {
        Properties result = new Properties();
        if (file == null) {
            return result;
        }
        if (!file.canRead()) {
            DVTLogger.INSTANCE.logInfo("Can't read " + file.getPath());
            return result;
        }
        if (file.length() > 0x2000000L) {
            DVTLogger.INSTANCE.logError("Preferences file '" + file.getAbsolutePath() + "' was ignored because it's larger than 32M!");
            return result;
        }
        Reader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            result.load(input);
        }
        catch (FileNotFoundException e) {
            DVTLogger.INSTANCE.logError(e);
            if (input == null) return result;
            try {
                input.close();
                return result;
            }
            catch (IOException iOException) {}
            return result;
        }
        catch (IOException e) {
            try {
                DVTLogger.INSTANCE.logError(e);
                if (input == null) return result;
            }
            catch (Throwable throwable) {
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                input.close();
                return result;
            }
            catch (IOException iOException) {}
            return result;
        }
        if (input == null) return result;
        try {
            input.close();
            return result;
        }
        catch (IOException iOException) {}
        return result;
    }

    private void writePreferencesToFile(Properties properties, File file) {
        try {
            StringWriter stringWriter = new StringWriter();
            properties.store(stringWriter, null);
            Object[] lines = stringWriter.toString().split("\\R");
            Arrays.sort(lines);
            Files.write(file.toPath(), Arrays.asList(lines), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private boolean createPreferencesFile(File file) {
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                DVTLogger.INSTANCE.logInfo("Can't create " + parent.getPath());
                return false;
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                DVTLogger.INSTANCE.logInfo("Can't write " + file.getPath());
                return false;
            }
        }
        if (!file.canWrite()) {
            DVTLogger.INSTANCE.logInfo("Can't write " + file.getPath());
            return false;
        }
        return true;
    }
}

