/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.settings;

import java.util.HashMap;
import ro.amiq.dvt.settings.mergers.FavoriteSearchesMerger;
import ro.amiq.dvt.settings.mergers.IPreferencesMerger;
import ro.amiq.dvt.settings.mergers.KeyBindingsMerger;
import ro.amiq.dvt.settings.mergers.TemplatesMerger;

public enum DVTSPreferencesMerger {
    INSTANCE;

    private final HashMap<String, IPreferencesMerger> fMergers = new HashMap();

    private DVTSPreferencesMerger() {
        this.fMergers.put("ro.amiq.edt/ro.amiq.edt.templates", new TemplatesMerger());
        this.fMergers.put("ro.amiq.vhdldt/ro.amiq.vhdldt.templates", new TemplatesMerger());
        this.fMergers.put("ro.amiq.vlogdt/ro.amiq.vlogdt.templates", new TemplatesMerger());
        this.fMergers.put("ro.amiq.dvt/favorite.searches", new FavoriteSearchesMerger());
        this.fMergers.put("org.eclipse.ui.workbench/org.eclipse.ui.commands", new KeyBindingsMerger());
    }

    private IPreferencesMerger getMerger(String key) {
        if (key == null) {
            return null;
        }
        return this.fMergers.get(key);
    }

    public static boolean equals(String key, String value1, String value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        IPreferencesMerger merger = INSTANCE.getMerger(key);
        if (merger == null) {
            return value1.equals(value2);
        }
        return merger.equals(value1, value2);
    }

    public static String merge(String key, String commonValue, String userValue) {
        IPreferencesMerger merger = INSTANCE.getMerger(key);
        if (merger == null) {
            if (userValue != null) {
                return userValue;
            }
            return commonValue;
        }
        return merger.merge(commonValue, userValue);
    }

    public static String unmerge(String key, String instanceValue, String defaultValue, String commonValue, String userValue) {
        IPreferencesMerger merger;
        if (commonValue == null) {
            return instanceValue;
        }
        if (commonValue.equals(instanceValue) && userValue == null) {
            return null;
        }
        if (instanceValue == null) {
            instanceValue = defaultValue;
        }
        if ((merger = INSTANCE.getMerger(key)) == null) {
            return instanceValue;
        }
        return merger.unmerge(instanceValue, commonValue, userValue);
    }
}

