/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.settings.commands;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.settings.DVTSPreferencesManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.utils.StringEditorUtils;

public class ShowPreferencesCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String parameterValue = event.getParameter("ro.amiq.dvt.settings.commands.ShowPreferencesParams");
        if (parameterValue == null || parameterValue.isEmpty()) {
            return null;
        }
        if (parameterValue.equals("unsaved")) {
            String content = this.propertiesToString(DVTSPreferencesManager.INSTANCE.getUnsavedPreferences());
            StringEditorUtils.INSTANCE.openString("Unsaved Preferences", content);
        } else if (parameterValue.equals("user")) {
            File file = DVTSFiles.PREFERENCES.getUserFile(true);
            if (file != null) {
                this.openFile(file);
            }
        } else if (parameterValue.equals("common")) {
            List<File> files = DVTSFiles.PREFERENCES.getCommonFiles(true);
            if (files != null) {
                for (File file : files) {
                    this.openFile(file);
                }
            }
        } else {
            return null;
        }
        return null;
    }

    private void openFile(File file) {
        IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)fileStore);
            }
            catch (PartInitException e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
    }

    private String propertiesToString(Properties properties) {
        try {
            StringWriter stringWriter = new StringWriter();
            properties.store(stringWriter, null);
            Object[] lines = stringWriter.toString().split("\\R");
            Arrays.sort(lines);
            return String.join((CharSequence)"\n", (CharSequence[])lines);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError(e);
            return "An error has occurred, see the log for more information!";
        }
    }
}

