/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.settings.mergers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import ro.amiq.dvt.settings.mergers.AMapMerger;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.favorites.FavoriteQuery;
import ro.amiq.dvt.ui.search.favorites.RfFavoriteUtils;

public class FavoriteSearchesMerger
extends AMapMerger<String, FavoriteQuery> {
    public static final String PREFERENCE_ID = "ro.amiq.dvt/favorite.searches";
    private final AMapMerger.IMapStringParser<String, FavoriteQuery> fParser = new AMapMerger.IMapStringParser<String, FavoriteQuery>(){
        private final TemplateReaderWriter fTemplateReaderWriter = new TemplateReaderWriter();

        @Override
        public String toString(Map<String, FavoriteQuery> map) {
            try {
                return RfFavoriteUtils.getSerializedPredefinedSearchQueries(this.transformFromMergerModelToInternalModel(map));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError(e);
                return "";
            }
        }

        @Override
        public Map<String, FavoriteQuery> toMap(String string) {
            try {
                return this.transformFromInternalModelToMergerModel(RfFavoriteUtils.getSearchQueries(string));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError(e);
                return Collections.emptyMap();
            }
        }

        private Map<String, List<FavoriteQuery>> transformFromMergerModelToInternalModel(Map<String, FavoriteQuery> map) {
            LinkedHashMap<String, List<FavoriteQuery>> result = new LinkedHashMap<String, List<FavoriteQuery>>();
            if (map == null || map.isEmpty()) {
                return result;
            }
            for (FavoriteQuery query : map.values()) {
                ArrayList<FavoriteQuery> queriesPerlanguage = (ArrayList<FavoriteQuery>)result.get(query.getLanguageKind());
                if (queriesPerlanguage == null) {
                    queriesPerlanguage = new ArrayList<FavoriteQuery>();
                    result.put(query.getLanguageKind(), queriesPerlanguage);
                }
                queriesPerlanguage.add(query);
            }
            return result;
        }

        private Map<String, FavoriteQuery> transformFromInternalModelToMergerModel(Map<String, List<FavoriteQuery>> map) {
            LinkedHashMap<String, FavoriteQuery> result = new LinkedHashMap<String, FavoriteQuery>();
            if (map == null || map.isEmpty()) {
                return result;
            }
            for (List<FavoriteQuery> queriesPerLanguage : map.values()) {
                if (queriesPerLanguage == null || queriesPerLanguage.isEmpty()) continue;
                for (FavoriteQuery query : queriesPerLanguage) {
                    result.put(query.getQueryLabel(), query);
                }
            }
            return result;
        }
    };

    @Override
    protected AMapMerger.IMapStringParser<String, FavoriteQuery> getParser() {
        return this.fParser;
    }
}

