/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.settings.mergers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import ro.amiq.dvt.settings.mergers.AMapMerger;

public class KeyBindingsMerger
extends AMapMerger<String, BindingWrapper> {
    public static final String PREFERENCE_ID = "org.eclipse.ui.workbench/org.eclipse.ui.commands";
    private final AMapMerger.IMapStringParser<String, BindingWrapper> fParser = new AMapMerger.IMapStringParser<String, BindingWrapper>(){
        private static final String SCHEME_ID_KEY = "!SCHEME_ID!";

        @Override
        public Map<String, BindingWrapper> toMap(String string) {
            if (string == null) {
                return Collections.emptyMap();
            }
            StringReader reader = new StringReader(string);
            LinkedHashMap<String, BindingWrapper> result = new LinkedHashMap<String, BindingWrapper>();
            try {
                IMemento[] bindingMementos;
                String schemeId;
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento schemeIdMemento = memento.getChild("activeKeyConfiguration");
                if (schemeIdMemento != null && (schemeId = schemeIdMemento.getString("keyConfigurationId")) != null) {
                    result.put(SCHEME_ID_KEY, new BindingWrapper(schemeId, null, null, null, null, null, null));
                }
                IMemento[] iMementoArray = bindingMementos = memento.getChildren("keyBinding");
                int n = bindingMementos.length;
                int n2 = 0;
                while (n2 < n) {
                    String keySequence;
                    String contextId;
                    String keyConfigurationId;
                    IMemento bindingMemento = iMementoArray[n2];
                    String commandId = this.readOptional(bindingMemento, "commandId");
                    if (commandId == null) {
                        commandId = this.readOptional(bindingMemento, "command");
                    }
                    if ((keyConfigurationId = this.readOptional(bindingMemento, "keyConfigurationId")) == null) {
                        keyConfigurationId = this.readOptional(bindingMemento, "configuration");
                    }
                    if ((contextId = this.readOptional(bindingMemento, "contextId")) == null) {
                        contextId = this.readOptional(bindingMemento, "scope");
                    }
                    if ((keySequence = this.readOptional(bindingMemento, "keySequence")) == null) {
                        keySequence = this.readOptional(bindingMemento, "string");
                    }
                    String locale = this.readOptional(bindingMemento, "locale");
                    String platform = this.readOptional(bindingMemento, "platform");
                    LinkedHashMap<String, String> parameterMap = null;
                    IMemento[] parameterMementos = bindingMemento.getChildren("parameter");
                    if (parameterMementos != null && parameterMementos.length != 0) {
                        parameterMap = new LinkedHashMap<String, String>();
                        IMemento[] iMementoArray2 = parameterMementos;
                        int n3 = parameterMementos.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemento parameterMemento = iMementoArray2[n4];
                            String id = parameterMemento.getString("id");
                            if (id != null && id.length() != 0) {
                                String value = parameterMemento.getString("value");
                                parameterMap.put(id, value);
                            }
                            ++n4;
                        }
                    }
                    BindingWrapper bindingWrapper = new BindingWrapper(keyConfigurationId, contextId, keySequence, locale, platform, commandId, parameterMap);
                    result.put(bindingWrapper.getId(), bindingWrapper);
                    ++n2;
                }
            }
            catch (WorkbenchException workbenchException) {}
            return result;
        }

        @Override
        public String toString(Map<String, BindingWrapper> map) {
            if (map == null) {
                return "";
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)"org.eclipse.ui.commands");
            BindingWrapper schemeId = map.get(SCHEME_ID_KEY);
            if (schemeId != null) {
                IMemento schemeIdMemento = memento.createChild("activeKeyConfiguration");
                schemeIdMemento.putString("keyConfigurationId", schemeId.fKeyConfigurationId);
            }
            for (BindingWrapper binding : map.values()) {
                IMemento bindingMemento = memento.createChild("keyBinding");
                bindingMemento.putString("contextId", binding.fContextId);
                bindingMemento.putString("commandId", binding.fCommandId);
                bindingMemento.putString("keyConfigurationId", binding.fKeyConfigurationId);
                bindingMemento.putString("keySequence", binding.fKeySequence);
                bindingMemento.putString("locale", binding.fLocale);
                bindingMemento.putString("platform", binding.fPlatform);
                if (binding.fParameterMap == null) continue;
                for (Map.Entry<String, String> entry : binding.fParameterMap.entrySet()) {
                    IMemento parameterElement = bindingMemento.createChild("parameter");
                    parameterElement.putString("id", entry.getKey());
                    parameterElement.putString("value", entry.getValue());
                }
            }
            StringWriter writer = new StringWriter();
            try {
                memento.save((Writer)writer);
            }
            catch (IOException iOException) {}
            return writer.toString();
        }

        protected String readOptional(IMemento memento, String attribute) {
            String value = memento.getString(attribute);
            if (value != null && value.length() == 0) {
                value = null;
            }
            return value;
        }
    };

    @Override
    protected AMapMerger.IMapStringParser<String, BindingWrapper> getParser() {
        return this.fParser;
    }

    public static class BindingWrapper {
        private final String fKeyConfigurationId;
        private final String fContextId;
        private final String fKeySequence;
        private final String fLocale;
        private final String fPlatform;
        private final String fCommandId;
        private final Map<String, String> fParameterMap;

        public BindingWrapper(String keyConfigurationId, String contextId, String keySequence, String locale, String platform, String commandId, Map<String, String> parameterMap) {
            this.fKeyConfigurationId = keyConfigurationId;
            this.fContextId = contextId;
            this.fKeySequence = keySequence;
            this.fLocale = locale;
            this.fPlatform = platform;
            this.fCommandId = commandId;
            this.fParameterMap = parameterMap;
        }

        public String getId() {
            return this.toString();
        }

        public String toString() {
            return "BindingWrapper [fKeyConfigurationId=" + this.fKeyConfigurationId + ", fContextId=" + this.fContextId + ", fKeySequence=" + this.fKeySequence + ", fLocale=" + this.fLocale + ", fPlatform=" + this.fPlatform + ", fCommandId=" + this.fCommandId + ", fParameterMap=" + this.fParameterMap + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fCommandId == null ? 0 : this.fCommandId.hashCode());
            result = 31 * result + (this.fContextId == null ? 0 : this.fContextId.hashCode());
            result = 31 * result + (this.fKeyConfigurationId == null ? 0 : this.fKeyConfigurationId.hashCode());
            result = 31 * result + (this.fKeySequence == null ? 0 : this.fKeySequence.hashCode());
            result = 31 * result + (this.fLocale == null ? 0 : this.fLocale.hashCode());
            result = 31 * result + (this.fParameterMap == null ? 0 : this.fParameterMap.hashCode());
            result = 31 * result + (this.fPlatform == null ? 0 : this.fPlatform.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BindingWrapper other = (BindingWrapper)obj;
            if (this.fCommandId == null ? other.fCommandId != null : !this.fCommandId.equals(other.fCommandId)) {
                return false;
            }
            if (this.fContextId == null ? other.fContextId != null : !this.fContextId.equals(other.fContextId)) {
                return false;
            }
            if (this.fKeyConfigurationId == null ? other.fKeyConfigurationId != null : !this.fKeyConfigurationId.equals(other.fKeyConfigurationId)) {
                return false;
            }
            if (this.fKeySequence == null ? other.fKeySequence != null : !this.fKeySequence.equals(other.fKeySequence)) {
                return false;
            }
            if (this.fLocale == null ? other.fLocale != null : !this.fLocale.equals(other.fLocale)) {
                return false;
            }
            if (this.fParameterMap == null ? other.fParameterMap != null : !this.fParameterMap.equals(other.fParameterMap)) {
                return false;
            }
            return !(this.fPlatform == null ? other.fPlatform != null : !this.fPlatform.equals(other.fPlatform));
        }
    }
}

