/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.settings.mergers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import ro.amiq.dvt.settings.mergers.AMapMerger;

public class TemplatesMerger
extends AMapMerger<String, TemplateWrapper> {
    public static final String PREFERENCE_ID_EDT = "ro.amiq.edt/ro.amiq.edt.templates";
    public static final String PREFERENCE_ID_VHDLDT = "ro.amiq.vhdldt/ro.amiq.vhdldt.templates";
    public static final String PREFERENCE_ID_VLOGDT = "ro.amiq.vlogdt/ro.amiq.vlogdt.templates";
    private final AMapMerger.IMapStringParser<String, TemplateWrapper> fParser = new AMapMerger.IMapStringParser<String, TemplateWrapper>(){
        private final TemplateReaderWriter fTemplateReaderWriter = new TemplateReaderWriter();

        @Override
        public String toString(Map<String, TemplateWrapper> map) {
            if (map == null || map.isEmpty()) {
                return "";
            }
            ArrayList<TemplatePersistenceData> datasList = new ArrayList<TemplatePersistenceData>();
            for (TemplateWrapper entry : map.values()) {
                datasList.add(entry.fData);
            }
            TemplatePersistenceData[] datas = datasList.toArray(new TemplatePersistenceData[datasList.size()]);
            StringWriter writer = new StringWriter();
            try {
                this.fTemplateReaderWriter.save(datas, (Writer)writer);
            }
            catch (IOException iOException) {}
            return writer.toString();
        }

        @Override
        public Map<String, TemplateWrapper> toMap(String string) {
            if (string == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, TemplateWrapper> result = new LinkedHashMap();
            try {
                TemplatePersistenceData[] datas;
                TemplatePersistenceData[] templatePersistenceDataArray = datas = this.fTemplateReaderWriter.read((Reader)new StringReader(string));
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplatePersistenceData data = templatePersistenceDataArray[n2];
                    TemplateWrapper wrapper = new TemplateWrapper(data);
                    result.put(wrapper.getKey(), wrapper);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                result = Collections.emptyMap();
            }
            return result;
        }
    };

    @Override
    protected AMapMerger.IMapStringParser<String, TemplateWrapper> getParser() {
        return this.fParser;
    }

    public static final class TemplateWrapper {
        private final TemplatePersistenceData fData;

        public TemplateWrapper(TemplatePersistenceData data) {
            this.fData = data;
        }

        public String getKey() {
            Template template;
            String id = this.fData.getId();
            if (id == null && (template = this.fData.getTemplate()) != null) {
                return "userTemplateName." + template.getName();
            }
            return id;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fData.isEnabled() ? 1231 : 1237);
            result = 31 * result + (this.fData.getTemplate() == null ? 0 : this.fData.getTemplate().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateWrapper other = (TemplateWrapper)obj;
            if (this.fData.isEnabled() != other.fData.isEnabled()) {
                return false;
            }
            return !(this.fData.getTemplate() == null ? other.fData.getTemplate() != null : !this.fData.getTemplate().equals((Object)other.fData.getTemplate()));
        }
    }
}

