/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.cli.CliConstants;
import ro.amiq.dvt.startup.cli.DVTCliHandler;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTCommandLineInterface
implements IStartup {
    private static CLIThread cliThread;

    public void earlyStartup() {
        this.writeLastWorkspaceLocation();
        if (cliThread == null) {
            DVTCommandLineInterface.startCLI();
        }
    }

    private void writeLastWorkspaceLocation() {
        try {
            File userDirFile;
            String userDir = System.getenv("DVT_USER_DIR");
            if (userDir == null) {
                userDir = String.valueOf(System.getProperty("user.home")) + File.separatorChar + ".dvt";
            }
            if (!(userDirFile = new File(userDir)).exists()) {
                userDirFile.mkdirs();
            }
            if (!userDirFile.isDirectory()) {
                return;
            }
            Files.write(new File(userDirFile, "last_workspace_path").toPath(), ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getCanonicalPath().getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private static void startCLI() {
        cliThread = new CLIThread();
        cliThread.start();
    }

    public static String getHost() {
        if (cliThread == null) {
            return null;
        }
        return DVTCommandLineInterface.cliThread.host;
    }

    public static int getPort() {
        if (cliThread == null) {
            return 0;
        }
        return DVTCommandLineInterface.cliThread.port;
    }

    private static class CLIThread
    extends Thread {
        private static final String DVT_CLI_SOCKET_FILENAME = "dvt_cli_socket";
        private static final String DVT_LOG_VAR = "DVT_LOG_LOCATION";
        private static final String DVT_LOG_FILE = "dvt_log_location";
        private static final int DVT_LOG_FILE_COUNT = 7500;
        private static final String DVT_PID_FILE = "dvt_pid";
        private static final Pattern TAB_PATTERN = Pattern.compile("\\t");
        private static final Pattern HAS_ERRORS = Pattern.compile("(?m)^" + Pattern.quote("[ERROR] ") + "\\s*(.*)");
        private int port;
        private String host;

        public CLIThread() {
            super("DVT CLI");
        }

        @Override
        public void run() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try {
                    ServerSocket serverSocket = new ServerSocket(0);
                    try {
                        this.port = serverSocket.getLocalPort();
                        try {
                            this.host = InetAddress.getLocalHost().getHostName();
                        }
                        catch (Exception e) {
                            this.safeLogError(e);
                        }
                        File ws = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                        this.writeToFile(new File(ws, DVT_CLI_SOCKET_FILENAME), String.valueOf(this.host) + " " + this.port);
                        this.saveDumpLocationAndPid();
                        while (true) {
                            Socket clientSocket = serverSocket.accept();
                            BufferedWriter out = new BufferedWriter(new PrintWriter(clientSocket.getOutputStream()));
                            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                            String commandLine = in.readLine();
                            if (commandLine != null) {
                                String[] commandParts;
                                ArrayList<String> commandArray = new ArrayList<String>();
                                String[] stringArray = commandParts = TAB_PATTERN.split(commandLine, 0);
                                int n = commandParts.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String commandPart = stringArray[n2];
                                    if (!commandPart.isEmpty()) {
                                        commandArray.add(commandPart);
                                    }
                                    ++n2;
                                }
                                StringBuilder resultBuilder = new StringBuilder();
                                try {
                                    resultBuilder.append(DVTCliHandler.handleCommand(commandArray));
                                }
                                catch (Exception e) {
                                    String unexpectedErrorText = "[ERROR] DVT CLI encountered an unexpected error:\n" + e.getMessage();
                                    out.write(unexpectedErrorText);
                                    resultBuilder.append(unexpectedErrorText);
                                }
                                String result = resultBuilder.toString();
                                Matcher matcher = HAS_ERRORS.matcher(result);
                                if (!CLIThread.isTestMode() && matcher.find() && matcher.groupCount() > 0) {
                                    this.openErrorDialog(matcher.group(1));
                                }
                                out.write(result);
                                ((Writer)out).flush();
                            }
                            clientSocket.shutdownInput();
                            clientSocket.shutdownOutput();
                            clientSocket.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (serverSocket != null) {
                            serverSocket.close();
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (!(e instanceof SocketException)) {
                    this.safeLogError(e);
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
                DVTCommandLineInterface.startCLI();
                return;
            }
        }

        private void saveDumpLocationAndPid() {
            try {
                File ws = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                String logVar = System.getenv(DVT_LOG_VAR);
                if (logVar == null || logVar.isEmpty()) {
                    return;
                }
                Deque<String> logFileList = CLIThread.getLogFileList();
                logFileList.addLast(logVar);
                if (logFileList.size() > 7500) {
                    logFileList.removeFirst();
                }
                StringBuilder logHistory = new StringBuilder();
                for (String logFile : logFileList) {
                    logHistory.append(String.valueOf(logFile) + "\n");
                }
                this.writeToFile(new File(ws, DVT_LOG_FILE), logHistory.toString());
                String pid = ManagementFactory.getRuntimeMXBean().getName();
                if (pid == null) {
                    return;
                }
                if (pid.indexOf(64) != -1) {
                    pid = pid.substring(0, pid.indexOf(64));
                }
                Integer.valueOf(pid);
                this.writeToFile(new File(ws, DVT_PID_FILE), String.valueOf(pid) + "\n");
            }
            catch (NumberFormatException numberFormatException) {}
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Deque<String> getLogFileList() {
            LinkedList<String> q = new LinkedList<String>();
            File ws = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(ws, DVT_LOG_FILE)));
                    try {
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                            String line;
                            while ((line = br.readLine()) != null) {
                                q.addLast(line);
                                if (q.size() <= 7500) continue;
                                q.removeFirst();
                            }
                        }
                        if (in == null) return q;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (in == null) throw throwable;
                        ((InputStream)in).close();
                        throw throwable;
                    }
                    ((InputStream)in).close();
                    return q;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            return q;
        }

        private void writeToFile(File f, String s) {
            try {
                Files.write(f.toPath(), s.getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }

        private void safeLogError(Throwable e) {
            try {
                DVTLogger.INSTANCE.logError(e);
            }
            catch (Throwable throwable) {}
        }

        private static boolean isTestMode() {
            return CliConstants.IS_TEST_MODE;
        }

        private void openErrorDialog(String errorMessage) {
            try {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "DVT CLI Error Encountered", null, errorMessage, 4, new String[]{IDialogConstants.OK_LABEL}, 0).open());
            }
            catch (Exception exception) {}
        }
    }
}

