/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup;

import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTPerspectiveSwitcher
implements IStartup {
    public static final String DVT_PERSPECTIVE = "DVT_PERSPECTIVE";
    public static final String DVT_SV_PERSPECTIVE = "SystemVerilog";
    public static final String DVT_E_PERSPECTIVE = "eLanguage";
    public static final String DVT_VHDL_PERSPECTIVE = "VHDL";
    public static final String DVT_DVT_PERSPECTIVE_NAME = "ro.amiq.dvt.ui.perspectives.DVTPerspective";
    public static final String DVT_SV_PERSPECTIVE_NAME = "ro.amiq.vlogdt.ui.perspectives.VlogPerspective";
    public static final String DVT_E_PERSPECTIVE_NAME = "ro.amiq.edt.ui.perspectives.EDTPerspective";
    public static final String DVT_VHDL_PERSPECTIVE_NAME = "ro.amiq.vhdldt.ui.perspectives.VhdlPerspective";
    public static final String DVT_MSDL_PERSPECTIVE_NAME = "ro.amiq.dvt.ui.perspectives.DVTPerspective";

    public void earlyStartup() {
        String perspectiveName = System.getenv(DVT_PERSPECTIVE);
        if (perspectiveName == null) {
            return;
        }
        if (DVT_SV_PERSPECTIVE.equalsIgnoreCase(perspectiveName)) {
            DVTPerspectiveSwitcher.switchPerspective(DVT_SV_PERSPECTIVE_NAME);
        } else if (DVT_E_PERSPECTIVE.equalsIgnoreCase(perspectiveName)) {
            DVTPerspectiveSwitcher.switchPerspective(DVT_E_PERSPECTIVE_NAME);
        } else if (DVT_VHDL_PERSPECTIVE.equalsIgnoreCase(perspectiveName)) {
            DVTPerspectiveSwitcher.switchPerspective(DVT_VHDL_PERSPECTIVE_NAME);
        } else {
            DVTPerspectiveSwitcher.switchPerspective(perspectiveName);
        }
    }

    public static void switchPerspective(final String perspectiveName) {
        try {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (activeWorkbenchWindow == null) {
                            return;
                        }
                        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                        if (activePage == null) {
                            return;
                        }
                        IPerspectiveDescriptor perspective = activePage.getPerspective();
                        if (perspective == null) {
                            return;
                        }
                        if (perspective.getId().equals(perspectiveName)) {
                            return;
                        }
                        PlatformUI.getWorkbench().showPerspective(perspectiveName, activeWorkbenchWindow);
                        IWorkbenchPart activePart = activePage.getActivePart();
                        if (activePart != null) {
                            activePart.setFocus();
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError(e);
                    }
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }
}

