/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;

public class DVTProjectImporter
implements IStartup {
    public static final String DVT_PROJECT_PATH = "DVT_PROJECT_PATH";
    public static final String DVT_PROJECT_OVERWRITE = "DVT_PROJECT_OVERWRITE";
    public static final String DVT_START_LINTING = "DVT_START_LINTING";
    private static String fLintTestImportHTMLReportLocation;
    private static String fLintTestAutoExportHTMLReportLocation;
    private static String fLintTestBaselineReportLocation;
    private static boolean fLintTestPrewaiveUnchangedFiles;
    private static boolean fLintTestMode;
    private static String fLintTestRulesetKindName;

    public void earlyStartup() {
        String projectToImport = System.getenv(DVT_PROJECT_PATH);
        if (projectToImport == null) {
            return;
        }
        try {
            DVTProjectImporter.importProject(projectToImport, Boolean.parseBoolean(System.getenv(DVT_START_LINTING)));
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public static void importProject(String projectToImport, boolean startLinting) throws CoreException {
        Path projectPath = new Path(projectToImport);
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        File directory = new File(projectPath.toOSString());
        if (!directory.isDirectory()) {
            DVTProjectImporter.popErrorDialog("Invalid project location", "The project you specified for import '" + projectToImport + "' does not exist.");
            return;
        }
        if (workspacePath.isPrefixOf((IPath)projectPath)) {
            DVTProjectImporter.popErrorDialog("Invalid project location", "The project you specified for import '" + projectToImport + "' must not be located in the current workspace '" + workspacePath + "'.");
            return;
        }
        File dotProjectFile = DVTProjectImporter.getProjectFileFromDirectory(directory);
        IProjectDescription description = null;
        if (dotProjectFile != null) {
            description = DVTProjectImporter.getProjectDescription(dotProjectFile);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (description == null) {
            return;
        }
        IProject project = workspace.getRoot().getProject(description.getName());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!project.exists()) {
            ResourcesPlugin.getWorkspace().run(DVTProjectImporter.importProjectRunnable(description, project, startLinting), (ISchedulingRule)workspaceRoot, 0, null);
        } else if (Boolean.parseBoolean(System.getenv(DVT_PROJECT_OVERWRITE))) {
            ResourcesPlugin.getWorkspace().run(DVTProjectImporter.deleteProjectRunnable(project), (ISchedulingRule)workspaceRoot, 0, null);
            ResourcesPlugin.getWorkspace().run(DVTProjectImporter.importProjectRunnable(description, project, startLinting), (ISchedulingRule)workspaceRoot, 0, null);
        } else {
            if (project.isOpen() && startLinting) {
                project.setSessionProperty(DVTStartupConstants.QN_DVT_DONT_RESTORE, (Object)true);
            }
            ResourcesPlugin.getWorkspace().run(DVTProjectImporter.refreshProjectRunnable((IResource)project), (ISchedulingRule)workspaceRoot, 0, null);
            if (startLinting) {
                ResourcesPlugin.getWorkspace().run(DVTProjectImporter.rebuildProjectRunnable(startLinting, project), (ISchedulingRule)workspaceRoot, 0, null);
            }
        }
    }

    private static IWorkspaceRunnable refreshProjectRunnable(final IResource project) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask("Refreshing Project...", 100);
                        project.refreshLocal(2, monitor);
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private static IWorkspaceRunnable importProjectRunnable(final IProjectDescription description, final IProject project, final boolean startLinting) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                block6: {
                    try {
                        try {
                            monitor.beginTask("Creating Project...", 100);
                            project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                            project.open(0, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
                            if (startLinting) {
                                project.setSessionProperty(DVTStartupConstants.QN_DVT_DONT_RESTORE, (Object)true);
                                project.setSessionProperty(DVTStartupConstants.QN_DVT_START_LINTING, (Object)"enable_autocorrect=false");
                                break block6;
                            }
                            project.setSessionProperty(DVTStartupConstants.QN_DVT_TRY_RESTORE, (Object)true);
                        }
                        catch (CoreException e) {
                            DVTLogger.INSTANCE.logError(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        };
    }

    private static IWorkspaceRunnable rebuildProjectRunnable(final boolean startLinting, final IProject project) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    try {
                        monitor.beginTask("Rebuilding Project...", 100);
                        if (!project.isOpen()) {
                            project.open(monitor);
                            if (startLinting) {
                                project.setSessionProperty(DVTStartupConstants.QN_DVT_DONT_RESTORE, (Object)true);
                            }
                        }
                        if (startLinting) {
                            project.setSessionProperty(DVTStartupConstants.QN_DVT_START_LINTING, (Object)"enable_autocorrect=false");
                        }
                        project.build(15, monitor);
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private static IWorkspaceRunnable deleteProjectRunnable(final IProject project) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    try {
                        monitor.beginTask("Deleting Project...", 100);
                        project.close(monitor);
                        project.delete(false, true, monitor);
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private static File getProjectFileFromDirectory(File directory) {
        File[] contents = directory.listFiles();
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.getName().equals(".project") && file.isFile()) {
                return file;
            }
            ++i;
        }
        return null;
    }

    private static IProjectDescription getProjectDescription(File projectSystemFile) {
        IProjectDescription description = null;
        try {
            Path path = new Path(projectSystemFile.getPath());
            description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
        }
        catch (Exception exception) {
            return null;
        }
        return description;
    }

    private static void popErrorDialog(final String dialogTitle, final String dialogMessage) {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    new MessageDialog(window.getShell(), dialogTitle, null, dialogMessage, 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                }
            }
        });
    }

    public static void setLintTestMode(boolean aLintTestMode) {
        fLintTestMode = aLintTestMode;
    }

    public static boolean isLintTestMode() {
        return fLintTestMode;
    }

    public static void setLintTestRulesetKindName(String aLintTestRulesetKindName) {
        fLintTestRulesetKindName = aLintTestRulesetKindName;
    }

    public static String getLintTestRulesetKindName() {
        return fLintTestRulesetKindName;
    }

    public static String getLintTestImportHTMLReportLocation() {
        return fLintTestImportHTMLReportLocation;
    }

    public static void setLintTestImportHTMLReportLocation(String lintTestImportHTMLReportLocation) {
        fLintTestImportHTMLReportLocation = lintTestImportHTMLReportLocation;
    }

    public static String getLintTestAutoExportHTMLReportLocation() {
        return fLintTestAutoExportHTMLReportLocation;
    }

    public static void setLintTestAutoExportHTMLReportLocation(String lintTestAutoExportHTMLReportLocation) {
        fLintTestAutoExportHTMLReportLocation = lintTestAutoExportHTMLReportLocation;
    }

    public static String getLintTestBaselineReportLocation() {
        return fLintTestBaselineReportLocation;
    }

    public static void setLintTestBaselineReportLocation(String lintTestBaselineReportLocation) {
        fLintTestBaselineReportLocation = lintTestBaselineReportLocation;
    }

    public static boolean getLintTestPrewaiveUnchangedFiles() {
        return fLintTestPrewaiveUnchangedFiles;
    }

    public static void setLintTestPrewaiveUnchangedFiles(boolean lintTestPrewaiveUnchangedFiles) {
        fLintTestPrewaiveUnchangedFiles = lintTestPrewaiveUnchangedFiles;
    }
}

