/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupPlugin;

public class DVTShutdownWatchdog
implements IStartup {
    private static final int TIMEOUT;

    static {
        int timeout = 60;
        try {
            String timeoutProperty = System.getProperty("ro.amiq.dvt.shutdown.timeout");
            if (timeoutProperty != null) {
                timeout = Integer.parseInt(timeoutProperty);
            }
        }
        catch (Exception exception) {}
        TIMEOUT = timeout;
    }

    public void earlyStartup() {
        if (TIMEOUT > 0) {
            int nofActiveEvents = 0;
            Event[] eventArray = Event.values();
            int n = eventArray.length;
            int n2 = 0;
            while (n2 < n) {
                Event event = eventArray[n2];
                try {
                    if (!event.isIgnored()) {
                        event.listen();
                        ++nofActiveEvents;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError(e);
                }
                ++n2;
            }
            if (nofActiveEvents > 0) {
                DVTLogger.INSTANCE.logInfo("Shutdown watchdog is enabled with " + TIMEOUT + " seconds timeout and " + nofActiveEvents + " / " + Event.values().length + " events");
            } else {
                DVTLogger.INSTANCE.logInfo("Shutdown watchdog is disabled because all events are ignored");
            }
        } else {
            DVTLogger.INSTANCE.logInfo("Shutdown watchdog is disabled because timeout is set to " + TIMEOUT);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Event {
        RUNTIME_SHUTDOWN{

            @Override
            void listen() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        Timer.I.start(RUNTIME_SHUTDOWN);
                    }
                });
            }
        }
        ,
        BUNDLE_STOPPED{

            @Override
            void listen() {
                DVTStartupPlugin.getContext().addBundleListener(e -> {
                    if (e.getBundle() != null && e.getType() == 4 && Objects.equals(e.getBundle().getSymbolicName(), "ro.amiq.dvt")) {
                        Timer.I.start(BUNDLE_STOPPED);
                    }
                });
            }
        }
        ,
        DISPLAY_SHELL_DISPOSED{

            @Override
            void listen() {
                Display.getDefault().syncExec(() -> Display.getDefault().addFilter(12, e -> {
                    if (e.widget instanceof Shell && PlatformUI.getWorkbench().getWorkbenchWindowCount() <= 0) {
                        Timer.I.start(DISPLAY_SHELL_DISPOSED);
                    }
                }));
            }
        }
        ,
        WORKBENCH_POST_SHUTDOWN{

            @Override
            void listen() {
                Display.getDefault().syncExec(() -> PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                    public void postShutdown(IWorkbench workbench) {
                        Timer.I.start(WORKBENCH_POST_SHUTDOWN);
                    }

                    public boolean preShutdown(IWorkbench workbench, boolean forced) {
                        return true;
                    }
                }));
            }
        }
        ,
        WORKBENCH_WINDOW_CLOSED{

            @Override
            void listen() {
                Display.getDefault().syncExec(() -> PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                    public void windowClosed(IWorkbenchWindow window) {
                        if (PlatformUI.getWorkbench().getWorkbenchWindowCount() <= 0) {
                            Timer.I.start(WORKBENCH_WINDOW_CLOSED);
                        }
                    }

                    public void windowOpened(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowActivated(IWorkbenchWindow window) {
                    }
                }));
            }
        };


        abstract void listen();

        boolean isIgnored() {
            return System.getProperty("ro.amiq.dvt.shutdown.ignore.events", "").toLowerCase().contains(this.name().toLowerCase());
        }
    }

    private static enum Timer {
        I;

        private final AtomicBoolean timerThreadStarted = new AtomicBoolean(false);
        private final Set<Event> triggers = Collections.synchronizedSet(new LinkedHashSet());

        synchronized void start(Event event) {
            this.triggers.add(event);
            this.startTimerThread();
        }

        private void startTimerThread() {
            if (this.timerThreadStarted.compareAndSet(false, true)) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(TIMEOUT));
                        }
                        catch (InterruptedException interruptedException) {}
                        System.err.println("JVM forcibly terminated " + TIMEOUT + " seconds after application exit was detected from these events: " + Arrays.stream(triggers.toArray()).map(e -> e.toString().toLowerCase()).collect(Collectors.joining(", ")));
                        Runtime.getRuntime().halt(0);
                    }
                };
                thread.setName("Shutdown Timer");
                thread.setDaemon(true);
                thread.start();
            }
        }
    }
}

