/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public class MouseTimeoutActionRunner {
    private static final int DELTA = 100;
    private Control fControl;
    private long fTimeout;
    private long fTimeoutTime;
    private Runnable fAction;
    private Runnable fWrapperRunnable = new Runnable(){

        @Override
        public void run() {
            if (MouseTimeoutActionRunner.this.fControl == null) {
                return;
            }
            if (MouseTimeoutActionRunner.this.fControl.isDisposed()) {
                return;
            }
            if (MouseTimeoutActionRunner.this.fControl.getShell() == null) {
                return;
            }
            if (MouseTimeoutActionRunner.this.fControl.getShell().isDisposed()) {
                return;
            }
            if (MouseTimeoutActionRunner.this.fTimeoutTime < System.currentTimeMillis()) {
                MouseTimeoutActionRunner.this.fAction.run();
                return;
            }
            if (DVTUiUtils.getAbsoluteBounds(MouseTimeoutActionRunner.this.fControl).contains(Display.getDefault().getCursorLocation())) {
                MouseTimeoutActionRunner.this.fTimeoutTime = System.currentTimeMillis() + MouseTimeoutActionRunner.this.fTimeout;
            }
            Display.getDefault().timerExec(100, MouseTimeoutActionRunner.this.fWrapperRunnable);
        }
    };

    public MouseTimeoutActionRunner(Control control, int timeout, Runnable action) {
        this.fControl = control;
        this.fTimeout = timeout;
        this.fAction = action;
    }

    public void start() {
        this.fTimeoutTime = System.currentTimeMillis() + this.fTimeout;
        Display.getDefault().timerExec(100, this.fWrapperRunnable);
    }
}

