/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.ICliHandlerDelegate;
import ro.amiq.dvt.startup.core.DVTLogger;

public class CliExtensionRegistry {
    private static final Object fSyncInstance = new Object();
    private static volatile HashMap<String, List<ICliHandlerDelegate>> fDelegates;
    private static final boolean DVT_ENABLE_SV_INTERP_DEBUG;
    private static final String RUN_PROJECT_COMMAND_NAME = "runProject";

    static {
        DVT_ENABLE_SV_INTERP_DEBUG = Boolean.parseBoolean(System.getenv("DVT_ENABLE_SV_INTERP_DEBUG"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ICliHandlerDelegate> getDelegates(String handlerVersion) {
        if (fDelegates == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                CliExtensionRegistry.computeDelegates();
            }
        }
        if (fDelegates.get(handlerVersion) == null) {
            return Collections.emptyList();
        }
        return fDelegates.get(handlerVersion);
    }

    private static void computeDelegates() {
        fDelegates = new HashMap();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("ro.amiq.dvt.cli");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if (!"cliHandlerDelegate".equals(configurationElement.getName())) {
                    DVTLogger.INSTANCE.logError(new DVTCliException("Invalid element: " + configurationElement + "for extension point: " + "ro.amiq.dvt.cli"));
                }
                try {
                    String cliHandlerVersion = configurationElement.getAttribute("cliHandlerVersion");
                    ICliHandlerDelegate cliHandlerDelegate = (ICliHandlerDelegate)configurationElement.createExecutableExtension("class");
                    if (DVT_ENABLE_SV_INTERP_DEBUG || !RUN_PROJECT_COMMAND_NAME.equals(cliHandlerDelegate.getCommandName())) {
                        List<ICliHandlerDelegate> delegates = fDelegates.get(cliHandlerVersion);
                        if (delegates == null) {
                            delegates = new ArrayList<ICliHandlerDelegate>();
                            fDelegates.put(cliHandlerVersion, delegates);
                        }
                        delegates.add(cliHandlerDelegate);
                    }
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError(e);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

