/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup.cli;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.startup.cli.CliExtensionRegistry;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliRunAfterException;
import ro.amiq.dvt.startup.cli.DVTCliRunnable;
import ro.amiq.dvt.startup.cli.ICliHandlerDelegate;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTCliHandlerV1 {
    private static final String COMMANDS = "commands";
    private static final String UNEXPECTED_ERROR_MESSAGE = "An unexpected error occurred. Please submit an issue report!";
    private DVTCliRunnable fRunAfter;
    private final ResultBuilder fResult = new ResultBuilder();

    public String getCommandList() {
        return "DVT CLI v1" + " " + COMMANDS + ":" + System.lineSeparator() + System.lineSeparator() + this.getDelegateCommandList();
    }

    public String handleCommand(final List<String> commandLine) {
        if (commandLine.isEmpty()) {
            return "";
        }
        final String cwd = commandLine.get(0);
        commandLine.remove(0);
        if (commandLine.isEmpty()) {
            return "";
        }
        if (Objects.equals(commandLine.get(0), "-silent")) {
            this.fResult.setSilent(true);
            commandLine.remove(0);
        }
        final String commandString = String.join((CharSequence)" ", commandLine);
        final String jobName = MessageFormat.format("DVT CLI v1: ''{0}''", commandString);
        WorkspaceJob cliJob = new WorkspaceJob(jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(jobName, -1);
                try {
                    if (Objects.equals(commandLine.get(0), DVTCliHandlerV1.COMMANDS)) {
                        DVTCliHandlerV1.this.fResult.appendInfo(DVTCliHandlerV1.this.getCommandList());
                    } else {
                        boolean handled = false;
                        for (ICliHandlerDelegate delegate : CliExtensionRegistry.getDelegates("v1")) {
                            if (!delegate.matches((String)commandLine.get(0))) continue;
                            if (delegate.c()) {
                                delegate.handle(monitor, DVTCliHandlerV1.this.fResult, cwd, commandLine);
                            } else {
                                DVTCliHandlerV1.this.fResult.appendError("License not available for this command. Check the DVT UI for details.");
                            }
                            handled = true;
                            break;
                        }
                        if (!handled) {
                            DVTCliHandlerV1.this.fResult.appendError("Unknown command: " + commandString);
                        }
                    }
                }
                catch (DVTCliRunAfterException e) {
                    DVTCliHandlerV1.this.fRunAfter = e.getRunnable();
                }
                catch (DVTCliException e) {
                    DVTCliHandlerV1.this.fResult.appendError(e.getMessage());
                }
                catch (Exception e) {
                    String message = e.getMessage() != null ? e.getMessage() : DVTCliHandlerV1.UNEXPECTED_ERROR_MESSAGE;
                    DVTCliHandlerV1.this.fResult.appendError(message);
                    DVTLogger.INSTANCE.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        cliJob.setUser(true);
        cliJob.schedule();
        try {
            cliJob.join();
        }
        catch (InterruptedException interruptedException) {
            this.fResult.appendError("DVT CLI Job Interrupted.");
        }
        if (this.fRunAfter != null) {
            Job runAfterJob = new Job(MessageFormat.format("DVT CLI v1 (post command): ''{0}''", this.fRunAfter.getDescription())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        DVTCliHandlerV1.this.fRunAfter.run(monitor, DVTCliHandlerV1.this.fResult);
                    }
                    catch (DVTCliException e) {
                        DVTCliHandlerV1.this.fResult.appendError(e.getMessage());
                    }
                    return Status.OK_STATUS;
                }
            };
            runAfterJob.setUser(true);
            runAfterJob.schedule();
            try {
                runAfterJob.join();
            }
            catch (InterruptedException interruptedException) {
                this.fResult.appendError("DVT CLI Job Interrupted.");
            }
        }
        return this.fResult.toString();
    }

    private String getDelegateCommandList() {
        StringBuilder result = new StringBuilder();
        for (ICliHandlerDelegate delegate : CliExtensionRegistry.getDelegates("v1")) {
            result.append(delegate.getCommandName()).append(System.lineSeparator());
        }
        return result.toString();
    }

    public static boolean checkVersion(List<String> commandLine) {
        return "v1".equals(commandLine.get(0));
    }

    public static class ResultBuilder {
        private boolean fSilent;
        private StringBuilder fResult = new StringBuilder();

        public void setSilent(boolean silent) {
            this.fSilent = silent;
        }

        public ResultBuilder appendInfo(String info) {
            if (!this.fSilent) {
                this.fResult.append("[INFO] " + info + System.lineSeparator());
            }
            return this;
        }

        public ResultBuilder appendError(String error) {
            this.fResult.append("[ERROR] " + error + System.lineSeparator());
            return this;
        }

        public ResultBuilder appendWarning(String warning) {
            if (!this.fSilent) {
                this.fResult.append("[WARNING] " + warning + System.lineSeparator());
            }
            return this;
        }

        public ResultBuilder append(String str) {
            this.fResult.append(str);
            return this;
        }

        public String toString() {
            return this.fResult.toString();
        }
    }
}

