/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup.cli;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DVTCliParser
extends GnuParser {
    private static final Matcher BUILD_FILE_MATCHER = Pattern.compile("-([a-zA-Z0-9_.-]+\\.build)").matcher("");

    public void processArgs(Option opt, ListIterator iter) throws ParseException {
        int nofArgs;
        while (iter.hasNext()) {
            String str = (String)iter.next();
            if (this.getOptions().hasOption(str) && str.startsWith("-")) {
                iter.previous();
                break;
            }
            try {
                Method m = Option.class.getDeclaredMethod("addValueForProcessing", String.class);
                m.setAccessible(true);
                m.invoke((Object)opt, DVTCliParser.stripLeadingAndTrailingQuotes(str));
            }
            catch (Exception exception) {
                iter.previous();
                break;
            }
        }
        if (opt.getValues() == null && !opt.hasOptionalArg()) {
            throw new MissingArgumentException(opt);
        }
        int n = nofArgs = opt.getValues() == null ? 0 : opt.getValues().length;
        if (opt.hasArgs() && opt.getArgs() != -2 && opt.getArgs() != nofArgs && !opt.hasOptionalArg()) {
            throw new MissingArgumentException(opt);
        }
    }

    protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder buildConfigContent = null;
        int i = 0;
        while (i < arguments.length) {
            String arg = arguments[i];
            if (BUILD_FILE_MATCHER.reset(arg).matches()) {
                if (buildConfigContent != null) {
                    tokens.add(buildConfigContent.toString());
                }
                buildConfigContent = new StringBuilder();
                tokens.add("-build_config");
                tokens.add(BUILD_FILE_MATCHER.group(1));
            } else if (buildConfigContent != null) {
                if (!buildConfigContent.toString().isEmpty()) {
                    buildConfigContent.append(" ");
                }
                buildConfigContent.append(arg);
            } else if ("-".equals(arg)) {
                tokens.add("-");
            } else if (arg.startsWith("-")) {
                String opt = DVTCliParser.stripLeadingHyphens(arg);
                if (options.hasOption(opt)) {
                    tokens.add(arg);
                } else if (opt.indexOf(61) != -1 && options.hasOption(opt.substring(0, opt.indexOf(61)))) {
                    tokens.add(arg.substring(0, arg.indexOf(61)));
                    tokens.add(arg.substring(arg.indexOf(61) + 1));
                } else if (options.hasOption(arg.substring(0, 2))) {
                    tokens.add(arg.substring(0, 2));
                    tokens.add(arg.substring(2));
                } else {
                    tokens.add(arg);
                }
            } else {
                tokens.add(arg);
            }
            ++i;
        }
        if (buildConfigContent != null && !buildConfigContent.toString().isEmpty()) {
            tokens.add(buildConfigContent.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static String stripLeadingHyphens(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("--")) {
            return str.substring(2, str.length());
        }
        if (str.startsWith("-")) {
            return str.substring(1, str.length());
        }
        return str;
    }

    static String stripLeadingAndTrailingQuotes(String str) {
        if (str.startsWith("\"") && str.endsWith("\"") && str.length() > 1) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }
}

