/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup.cli;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.startup.DVTCommandLineInterface;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class InfoHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String message = null;
        message = DVTCommandLineInterface.getPort() == 0 ? "DVT CLI is not enabled." : "DVT CLI is enabled.";
        new MessageDialog(DVTUiUtils.getActiveWorkbenchWindow().getShell(), "DVT CLI Information", null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0){

            protected Control createCustomArea(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout());
                GridData gd = new GridData(4, 4, true, true);
                composite.setLayoutData((Object)gd);
                Text text = new Text(composite, 8);
                text.setEditable(false);
                DVTColorUtil.INSTANCE.setBackground((Control)text, DVTColorUtil.INSTANCE.getBackground((Control)text.getParent()), true);
                String hostport = "Running on port " + DVTCommandLineInterface.getPort();
                if (DVTCommandLineInterface.getHost() != null) {
                    hostport = String.valueOf(hostport) + " on host " + DVTCommandLineInterface.getHost();
                }
                text.setText(hostport);
                new Label(composite, 0).setText("Available commands: ");
                Text commands = new Text(composite, 2560);
                commands.setEditable(false);
                commands.setText(new DVTCliHandlerV1().getCommandList());
                GridData layoutData = new GridData(4, 4, true, true);
                layoutData.heightHint = 150;
                commands.setLayoutData((Object)layoutData);
                Link link = new Link(composite, 0);
                link.setText("For the full reference please see <a>Command Line Interface</a> chapter in the relevant DVT documentation.");
                DVTUiUtils.setPlatformLinkColor(link);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DVTUiUtils.openHelpPage("Command_Line_Interface.html");
                    }
                });
                return composite;
            }
        }.open();
        return null;
    }
}

