/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup.core;

import java.lang.management.ManagementFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import ro.amiq.dvt.startup.core.DVTStartupPlugin;

public enum DVTLogger {
    INSTANCE;

    private static final boolean DVT_DEBUG_MODE;
    private static final boolean JVM_DEBUG_MODE;
    private static ILog logger;

    static {
        DVT_DEBUG_MODE = Boolean.parseBoolean(System.getenv("DVT_DEBUG_MODE"));
        JVM_DEBUG_MODE = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;
        logger = null;
    }

    public void logInfo(String message) {
        this.log(1, 0, message, null);
    }

    public void logDebug(String message) {
        this.log(1, 0, message, null);
    }

    public void logDebug(String enabler, String message) {
        if (System.getenv(enabler) != null) {
            this.log(1, 0, message, null);
        }
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(Throwable e) {
        this.logError(null, e);
    }

    public void logError(String message, Throwable e) {
        if (message == null) {
            message = "Unexpected exception";
        }
        if (DVT_DEBUG_MODE) {
            if (message != null) {
                System.err.print(message);
            }
            if (e != null) {
                e.printStackTrace(System.err);
            }
        }
        this.log(4, 0, message, e);
    }

    private void log(int error, int ok, String message, Throwable e) {
        DVTLogger.log((IStatus)new Status(error, "ro.amiq.dvt", ok, "DVT Logger: " + message, e));
    }

    private static void log(IStatus status) {
        DVTStartupPlugin pluginDefault = DVTStartupPlugin.getDefault();
        if (pluginDefault == null) {
            return;
        }
        if (pluginDefault.getBundle() == null) {
            ResourcesPlugin.getPlugin().getLog().log(status);
            return;
        }
        if (logger == null) {
            logger = pluginDefault.getLog();
        }
        try {
            logger.log(status);
        }
        catch (Exception exception) {
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public boolean isDebugMode() {
        return DVT_DEBUG_MODE;
    }

    public boolean isJVMDebugMode() {
        return JVM_DEBUG_MODE;
    }
}

