/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import ro.amiq.dvt.startup.core.EclipseUtils;

public class DVTStartupPlugin
extends Plugin {
    public static final String ID = "ro.amiq.dvt.startup";
    private static BundleContext fContext;
    private static DVTStartupPlugin fPlugin;

    public DVTStartupPlugin() {
        this.setAppData();
    }

    private void setAppData() {
        String javaVersion;
        String eclipseVersion;
        ArrayList<String> info = new ArrayList<String>();
        info.add("ad");
        String dvtVersion = (String)this.getBundle().getHeaders().get("Bundle-Version");
        if (dvtVersion != null) {
            info.add("v" + dvtVersion);
        }
        if ((eclipseVersion = String.valueOf(EclipseUtils.getVersion().getMajor()) + "." + EclipseUtils.getVersion().getMinor()) != null) {
            info.add("e" + eclipseVersion);
        }
        if ((javaVersion = System.getProperty("java.specification.version", null)) != null) {
            info.add("j" + javaVersion);
        }
        System.setProperty("ro.amiq.dvt.flclient.app.data", String.join((CharSequence)"-", info));
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        fPlugin = this;
        fContext = bundleContext;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        fPlugin = null;
        fContext = null;
        super.stop(bundleContext);
    }

    public static DVTStartupPlugin getDefault() {
        return fPlugin;
    }

    public static BundleContext getContext() {
        return fContext;
    }
}

