/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup.core;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchWindow;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class DVTUiUtils {
    private static final String DVT_DEFAULT_TOOLTIP_TEXT_KEY = "ro.amiq.dvt.tooltip_text_key";
    private static final String DVT_QUICK_TOOLTIP_KEYDATA = "dvt_quick_tooltip";
    private static final String DVT_DOUBLE_FONT = "DVTDoubleFont";
    public static final Color COLOR_RED = new Color(null, 255, 214, 214);
    public static final Color COLOR_GREEN = new Color(null, 214, 255, 214);
    public static final Color COLOR_GRAY = new Color(null, 192, 192, 192);
    public static final Color COLOR_YELLOW = new Color(null, 245, 245, 181);
    public static final Color COLOR_BLACK = new Color(null, 0, 0, 0);
    public static final int DEFAULT_WINDOW_WIDTH = 1280;
    public static final int DEFAULT_WINDOW_HEIGHT = 768;
    public static final String PREFERENCE_COLOR_FOREGROUND_SYSTEM_DEFAULT = "AbstractTextEditor.Color.Foreground.SystemDefault";
    public static final String PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT = "AbstractTextEditor.Color.Background.SystemDefault";
    public static final String PREFERENCE_COLOR_FOREGROUND = "AbstractTextEditor.Color.Foreground";
    public static final String PREFERENCE_COLOR_BACKGROUND = "AbstractTextEditor.Color.Background";

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        final IWorkbenchWindow[] result = new IWorkbenchWindow[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
        });
        return result[0];
    }

    public static void openHelpPage(String page) {
        String perspective = null;
        try {
            perspective = DVTUiUtils.getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError(ex);
        }
        String plugin = "vlogdt";
        if ("ro.amiq.edt.ui.perspectives.EDTPerspective".equals(perspective)) {
            plugin = "edt";
        } else if ("ro.amiq.vhdldt.ui.perspectives.VhdlPerspective".equals(perspective)) {
            plugin = "vhdldt";
        }
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/ro.amiq." + plugin + ".help/help/" + page);
    }

    public static void redrawToolbarInCoolbar(String toolbarID) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        DVTUiUtils.redrawToolbarInCoolbar(window, toolbarID);
    }

    public static void redrawToolbarInCoolbar(IWorkbenchWindow window, String toolbarID) {
        ICoolBarManager coolbarManager = DVTUiUtils.getCoolBarManager(window);
        if (coolbarManager == null) {
            return;
        }
        coolbarManager.update(true);
        IToolBarManager toolbarManager = DVTUiUtils.getToolbarManager(coolbarManager, toolbarID);
        if (toolbarManager == null) {
            return;
        }
        toolbarManager.update(true);
    }

    private static ICoolBarManager getCoolBarManager(IWorkbenchWindow window) {
        if (window == null || !(window instanceof WorkbenchWindow)) {
            return null;
        }
        return ((WorkbenchWindow)window).getCoolBarManager2();
    }

    public static IToolBarManager getToolbarManager(String toolbarID) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICoolBarManager coolbarManager = DVTUiUtils.getCoolBarManager(window);
        return DVTUiUtils.getToolbarManager(coolbarManager, toolbarID);
    }

    public static IToolBarManager getToolbarManager(IWorkbenchWindow window, String toolbarID) {
        ICoolBarManager coolbarManager = DVTUiUtils.getCoolBarManager(window);
        return DVTUiUtils.getToolbarManager(coolbarManager, toolbarID);
    }

    private static IToolBarManager getToolbarManager(ICoolBarManager coolBarManager, String toolbarID) {
        if (coolBarManager == null) {
            return null;
        }
        IContributionItem toolbar = coolBarManager.find(toolbarID);
        if (toolbar == null || !(toolbar instanceof ToolBarContributionItem)) {
            return null;
        }
        return ((ToolBarContributionItem)toolbar).getToolBarManager();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DVTUiUtils.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = DVTUiUtils.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getActivePart();
    }

    public static void showBusyIndicator(final AtomicBoolean jobStatus, final long busyIndicatorTimeout) {
        final Display display = Display.getCurrent();
        DVTUiUtils.runWithBusyIndicator(new Runnable(){

            @Override
            public void run() {
                while (!jobStatus.get() && System.currentTimeMillis() < busyIndicatorTimeout) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }

    public static void runWithBusyIndicator(Runnable runnable) {
        DVTUiUtils.setUserInterfaceActive(false);
        try {
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)runnable);
        }
        finally {
            DVTUiUtils.setUserInterfaceActive(true);
        }
    }

    private static void setUserInterfaceActive(boolean active) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        if (active) {
            int i = 0;
            while (i < shells.length) {
                shells[i].setEnabled(active);
                ++i;
            }
        } else {
            int i = shells.length - 1;
            while (i >= 0) {
                shells[i].setEnabled(active);
                --i;
            }
        }
    }

    public static void showProgressMonitorDialogIfJobNotDone(final Job job, final AtomicBoolean jobStatus, final String displayString) {
        if (jobStatus.get()) {
            return;
        }
        final Display display = Display.getCurrent();
        Shell shell = DVTUiUtils.getActiveWorkbenchShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    if (jobStatus.get()) {
                        return;
                    }
                    monitor.beginTask(displayString, -1);
                    while (!jobStatus.get()) {
                        if (monitor.isCanceled()) {
                            job.cancel();
                            break;
                        }
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public static void showBusyIndAndProgressMonitorAfterTImeout(Job job, AtomicBoolean jobStatus, String displayString, long busyIndicatorTimeout) {
        DVTUiUtils.showBusyIndicator(jobStatus, busyIndicatorTimeout);
        DVTUiUtils.showProgressMonitorDialogIfJobNotDone(job, jobStatus, displayString);
    }

    public static Rectangle getAbsoluteBounds(Control control) {
        if (control instanceof Shell) {
            return control.getBounds();
        }
        Rectangle result = control.getBounds();
        Point absolute = control.toDisplay(result.x, result.y);
        result.x = absolute.x;
        result.y = absolute.y;
        return result;
    }

    public static Point getWindowSize() {
        Shell shell = DVTUiUtils.getActiveWorkbenchShell();
        if (shell != null) {
            return shell.getSize();
        }
        return null;
    }

    public static void setPlatformEditorColors(Control c) {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        DVTColorUtil.INSTANCE.setForeground(c, store.getBoolean(PREFERENCE_COLOR_FOREGROUND_SYSTEM_DEFAULT) ? DVTColorUtil.INSTANCE.getSystemColor(24) : DVTUiUtils.createColor(store, PREFERENCE_COLOR_FOREGROUND));
        DVTColorUtil.INSTANCE.setBackground(c, store.getBoolean(PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT) ? DVTColorUtil.INSTANCE.getSystemColor(25) : DVTUiUtils.createColor(store, PREFERENCE_COLOR_BACKGROUND));
    }

    private static Color createColor(IPreferenceStore store, String key) {
        if (!store.contains(key)) {
            return null;
        }
        RGB rgb = null;
        rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        if (rgb == null) {
            return null;
        }
        return DVTColorUtil.INSTANCE.getColor(rgb);
    }

    public static void setPlatformLinkColor(Link link) {
        if (link != null && EclipseUtils.isAtLeastEclipse46()) {
            try {
                Method setLinkForegroundMethod = Link.class.getDeclaredMethod("setLinkForeground", Color.class);
                setLinkForegroundMethod.invoke((Object)link, JFaceResources.getColorRegistry().get("HYPERLINK_COLOR"));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
    }

    public static Font getDoubleFont() {
        FontData[] doubleFont;
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        if (fontRegistry.hasValueFor(DVT_DOUBLE_FONT)) {
            return fontRegistry.get(DVT_DOUBLE_FONT);
        }
        Font defaultFont = fontRegistry.get("org.eclipse.jface.defaultfont");
        FontData[] fontDataArray = doubleFont = defaultFont.getFontData();
        int n = doubleFont.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setHeight((int)((double)fontData.getHeight() * 1.6));
            ++n2;
        }
        fontRegistry.put(DVT_DOUBLE_FONT, doubleFont);
        return fontRegistry.get(DVT_DOUBLE_FONT);
    }

    public static void installQuickTooltip(final Control control, String text) {
        if (control == null) {
            return;
        }
        Object meta = control.getData(DVT_QUICK_TOOLTIP_KEYDATA);
        if (!(meta instanceof DefaultToolTip)) {
            final DefaultToolTip toolTip = new DefaultToolTip(control, 0, true);
            toolTip.setText(text);
            control.setData(DVT_QUICK_TOOLTIP_KEYDATA, (Object)toolTip);
            control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    toolTip.hide();
                }

                public void mouseEnter(MouseEvent e) {
                    toolTip.show(new Point(0, control.getBounds().height + 5));
                }
            });
        } else {
            ((DefaultToolTip)meta).setText(text);
        }
    }

    public static void installTooltipFloatingNotification(Control control, String text, Point destination) {
        if (control == null) {
            return;
        }
        Object meta = control.getData(DVT_QUICK_TOOLTIP_KEYDATA);
        if (!(meta instanceof DefaultToolTip)) {
            DefaultToolTip toolTip = new DefaultToolTip(control, 0, true);
            toolTip.setText(text);
            toolTip.setData(DVT_DEFAULT_TOOLTIP_TEXT_KEY, (Object)text);
            control.setData(DVT_QUICK_TOOLTIP_KEYDATA, (Object)toolTip);
            toolTip.show(destination);
        } else {
            DefaultToolTip toolTip = (DefaultToolTip)meta;
            Object data = toolTip.getData(DVT_DEFAULT_TOOLTIP_TEXT_KEY);
            if (!text.equals(data)) {
                toolTip.hide();
                toolTip.setText(text);
                toolTip.setData(DVT_DEFAULT_TOOLTIP_TEXT_KEY, (Object)text);
                toolTip.show(destination);
            } else {
                toolTip.show(destination);
            }
        }
    }

    public static void hideTooltipFloatingNotification(Control control) {
        if (control == null) {
            return;
        }
        Object meta = control.getData(DVT_QUICK_TOOLTIP_KEYDATA);
        if (!(meta instanceof DefaultToolTip)) {
            return;
        }
        ((DefaultToolTip)meta).hide();
    }

    public static boolean isUiThread() {
        return Display.getCurrent() != null;
    }

    public static IEditorPart getEditor(IDocument document) {
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getActiveEditor();
    }

    public static IEditorPart getEditor(IResource fFileDefAdapter) {
        try {
            return IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)fFileDefAdapter));
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
    }

    public static Composite getTrimToolbarParent(Composite element) {
        if ("org.eclipse.jface.action.StatusLine".equals(element.getClass().getName())) {
            return element.getParent();
        }
        Control[] children = element.getChildren();
        if (children == null) {
            return null;
        }
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Composite childResult;
            Control child = controlArray[n2];
            if (child instanceof Composite && (childResult = DVTUiUtils.getTrimToolbarParent((Composite)child)) != null) {
                return childResult;
            }
            ++n2;
        }
        return null;
    }
}

