/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup.variableresolvers;

import java.util.HashMap;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class DVTAutolinkVariableHelper {
    private static final String AUTOLINK_ROOT_ENV_VAR_PREFIX = "AUTOLINK_ROOT_VAR-";
    private static DVTAutolinkVariableHelper fInstance = null;

    public static DVTAutolinkVariableHelper getInstance() {
        if (fInstance == null) {
            fInstance = new DVTAutolinkVariableHelper();
        }
        return fInstance;
    }

    private DVTAutolinkVariableHelper() {
    }

    public String getValueForVariable(String variable, IResource resource) {
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (!(project instanceof Project)) {
            return null;
        }
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return null;
        }
        HashMap variables = projectDescription.getVariables();
        if (variables == null || variables.isEmpty()) {
            return null;
        }
        VariableDescription variableDescription = (VariableDescription)variables.get(AUTOLINK_ROOT_ENV_VAR_PREFIX + variable);
        if (variableDescription == null) {
            return null;
        }
        return variableDescription.getValue();
    }
}

