/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.startup.variableresolvers;

import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.variableresolvers.PathVariableResolver;
import ro.amiq.dvt.startup.variableresolvers.DVTAutolinkVariableHelper;

public class DVTEnvVariableResolver
extends PathVariableResolver {
    public static final String NAME = "DVT_ENV";
    public static final Pattern SYSTEM_VARIABLE_PATTERN = Pattern.compile("\\$\\{?([a-zA-Z_][a-zA-Z0-9_]*)\\}?|%([a-zA-Z_][a-zA-Z0-9_]*)%", 8);

    public String getValue(String variable, IResource resource) {
        int index = variable.indexOf(45);
        if (index == -1 || index == variable.length() - 1) {
            return null;
        }
        String systemVariableName = variable.substring(index + 1);
        if (systemVariableName == null) {
            return null;
        }
        String systemVariableValue = System.getenv(systemVariableName);
        if (systemVariableValue == null) {
            if (resource == null) {
                return null;
            }
            systemVariableValue = DVTAutolinkVariableHelper.getInstance().getValueForVariable(systemVariableName, resource);
        }
        if (systemVariableValue == null) {
            return null;
        }
        URI file = new File(systemVariableValue).toURI();
        if (file == null) {
            return null;
        }
        return file.toASCIIString();
    }

    public static String toDvtEnvVariables(CharSequence input) {
        StringBuffer replaceSB = new StringBuffer();
        Matcher tmpM = SYSTEM_VARIABLE_PATTERN.matcher(input);
        while (tmpM.find()) {
            String replacement = null;
            if (tmpM.group(1) == null && tmpM.group(2) == null) {
                return null;
            }
            if (tmpM.group(1) != null) {
                replacement = "${DVT_ENV-" + tmpM.group(1) + "}";
            } else if (tmpM.group(2) != null) {
                replacement = "${DVT_ENV-" + tmpM.group(2) + "}";
            }
            if (replacement == null) {
                return null;
            }
            tmpM.appendReplacement(replaceSB, Matcher.quoteReplacement(replacement));
        }
        tmpM.appendTail(replaceSB);
        return replaceSB.toString();
    }
}

