/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.stickyproject;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import ro.amiq.dvt.settings.DVTSConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupPlugin;
import ro.amiq.dvt.startup.core.EclipseUtils;

public enum DVTSettingsProjectManager {
    INSTANCE;


    public void init(boolean enabled) {
        if (enabled) {
            this.createStickyProjectJob(0L);
            this.addStickyProjectListener();
        } else {
            this.removeStickyProjectJob(0L);
        }
    }

    private void addStickyProjectListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(event -> {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("DVT-Settings");
            if (project == null) {
                return;
            }
            if (event.getType() == 2 && project.equals((Object)event.getResource())) {
                this.openStickyProjectJob(3000L);
            } else if (event.getType() == 1) {
                IResourceDelta projectDelta = event.getDelta().findMember(project.getFullPath());
                if (projectDelta == null) {
                    return;
                }
                int kind = projectDelta.getKind();
                if (kind == 2 || kind == 4) {
                    IPath movedToPath = projectDelta.getMovedToPath();
                    if (movedToPath != null) {
                        this.renameStickyProjectJob(movedToPath);
                    } else {
                        this.createStickyProjectJob(2000L);
                    }
                }
            }
        }, 3);
    }

    private void createStickyProjectJob(long delay) {
        final Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        final IWorkspaceRoot root = workspace.getRoot();
        WorkspaceJob job = new WorkspaceJob("Creating DVT-Settings"){

            /*
             * Unable to fully structure code
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                block5: {
                    workspace.prepareOperation((ISchedulingRule)root, monitor);
                    workspace.beginOperation(true);
                    projectByName = root.getProject("DVT-Settings");
                    projectPath = DVTStartupPlugin.getDefault().getStateLocation().append("DVT-Settings");
                    projectFolder = projectPath.toFile();
                    if (projectByName.exists()) ** GOTO lbl22
                    if (projectFolder.exists() || projectFolder.mkdir()) break block5;
                    DVTLogger.INSTANCE.logError("Can't create new DVT-Settings directory: " + projectFolder.getAbsolutePath());
                    var7_6 = Status.CANCEL_STATUS;
                    DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() != false ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                    return var7_6;
                }
                try {
                    try {
                        projectFolder.setWritable(true);
                        description = workspace.newProjectDescription(projectByName.getName());
                        description.setLocation(projectPath);
                        projectByName.create(description, monitor);
                        projectByName.open(monitor);
lbl22:
                        // 2 sources

                        DVTSettingsProjectManager.this.postCreate(projectByName, monitor);
                    }
                    catch (IOException | CoreException e) {
                        DVTLogger.INSTANCE.logError(e);
                        var7_7 = Status.CANCEL_STATUS;
                        DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() != false ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                        return var7_7;
                    }
                }
                catch (Throwable var6_9) {
                    DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() != false ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                    throw var6_9;
                }
                DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() != false ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)root);
        job.schedule(delay);
    }

    private void postCreate(IProject projectByName, IProgressMonitor monitor) throws CoreException, IOException {
        Map<IResource, Boolean> currentFolders = Stream.of(projectByName.members()).filter(resource -> resource.getName().startsWith("common") || resource.getName().startsWith("user")).collect(Collectors.toMap(resource -> resource, resource -> false));
        if (DVTSConstants.DVT_COMMON_SETTINGS != null) {
            if (DVTSConstants.DVT_COMMON_SETTINGS.length > 1) {
                int i = 1;
                while (i <= DVTSConstants.DVT_COMMON_SETTINGS.length) {
                    DVTSettingsProjectManager.createLinkedFolder(projectByName, "common-" + i, DVTSConstants.DVT_COMMON_SETTINGS[i - 1], currentFolders);
                    ++i;
                }
            } else {
                DVTSettingsProjectManager.createLinkedFolder(projectByName, "common", DVTSConstants.DVT_COMMON_SETTINGS[0], currentFolders);
            }
        }
        if (DVTSConstants.DVT_USER_SETTINGS != null) {
            File userSettingsDir = new File(DVTSConstants.DVT_USER_SETTINGS);
            if (!userSettingsDir.exists() && !userSettingsDir.mkdirs()) {
                DVTLogger.INSTANCE.logError("Can't create new user settings directory: " + userSettingsDir.getAbsolutePath());
            }
            DVTSettingsProjectManager.createLinkedFolder(projectByName, "user", DVTSConstants.DVT_USER_SETTINGS, currentFolders);
        }
        for (Map.Entry<IResource, Boolean> entry : currentFolders.entrySet()) {
            IResource resource2;
            if (Boolean.TRUE.equals(entry.getValue()) || (resource2 = entry.getKey()) == null) continue;
            resource2.delete(false, monitor);
        }
    }

    public void removeStickyProjectJob(long delay) {
        final Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        final IWorkspaceRoot root = workspace.getRoot();
        WorkspaceJob job = new WorkspaceJob("Remove DVT-Settings"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                block4: {
                    IStatus iStatus;
                    try {
                        workspace.prepareOperation((ISchedulingRule)root, monitor);
                        workspace.beginOperation(true);
                        if (DVTSettingsProjectManager.this.removeStickyProject(root, monitor)) break block4;
                        iStatus = Status.CANCEL_STATUS;
                    }
                    catch (CoreException e) {
                        IStatus iStatus2;
                        try {
                            DVTLogger.INSTANCE.logError(e);
                            iStatus2 = Status.CANCEL_STATUS;
                        }
                        catch (Throwable throwable) {
                            DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            throw throwable;
                        }
                        DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                        return iStatus2;
                    }
                    DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                    return iStatus;
                }
                DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)root);
        job.schedule(delay);
    }

    private void renameStickyProjectJob(final IPath movedToPath) {
        final Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        final IWorkspaceRoot root = workspace.getRoot();
        WorkspaceJob job = new WorkspaceJob("Renaming DVT-Settings"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                block6: {
                    try {
                        try {
                            workspace.prepareOperation((ISchedulingRule)root, monitor);
                            workspace.beginOperation(true);
                            IProject movedProject = root.getProject(movedToPath.toOSString());
                            if (movedProject.exists() && movedProject.isAccessible()) {
                                IProjectDescription description = movedProject.getDescription();
                                description.setName("DVT-Settings");
                                movedProject.move(description, true, monitor);
                            }
                        }
                        catch (CoreException e) {
                            DVTLogger.INSTANCE.logError(e);
                            DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                        throw throwable;
                    }
                    DVTSettingsProjectManager.this.reflectionWorkspaceEndOperation(workspace, (ISchedulingRule)root, false, EclipseUtils.isAtLeastEclipse47() ? null : Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)root);
        job.schedule(1000L);
    }

    private void openStickyProjectJob(long delay) {
        final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        WorkspaceJob job = new WorkspaceJob("Opening DVT-Settings"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    IProject projectByName = root.getProject("DVT-Settings");
                    projectByName.open(monitor);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)root);
        job.schedule(delay);
    }

    private boolean removeStickyProject(IWorkspaceRoot root, IProgressMonitor monitor) throws CoreException {
        IProject[] allProjects;
        IProject projectByName = root.getProject("DVT-Settings");
        if (projectByName.exists()) {
            projectByName.delete(false, true, monitor);
        }
        IPath projectPath = DVTStartupPlugin.getDefault().getStateLocation().append("DVT-Settings");
        IProject[] iProjectArray = allProjects = root.getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getLocation().equals((Object)projectPath) && project.exists()) {
                project.delete(false, true, monitor);
                break;
            }
            ++n2;
        }
        File file = projectPath.toFile();
        if (file.exists() && !this.deleteFolder(file)) {
            DVTLogger.INSTANCE.logError("Can't remove old DVT-Settings directory: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    private boolean deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    this.deleteFolder(f);
                } else {
                    try {
                        Files.delete(f.toPath());
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError(e);
                    }
                }
                ++n2;
            }
        }
        try {
            Files.delete(folder.toPath());
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
        return true;
    }

    private static void createLinkedFolder(IProject project, String name, String path, Map<IResource, Boolean> currentFolders) throws CoreException, IOException {
        int validationStatus;
        File locationFile = new File(path);
        if (!locationFile.exists() && !"user".equals(name)) {
            return;
        }
        IPath locationPath = Path.fromOSString((String)locationFile.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString());
        IFolder link = project.getFolder(name);
        currentFolders.put((IResource)link, true);
        if (link.exists()) {
            if (Paths.get(locationPath.toOSString(), new String[0]).equals(Paths.get(link.getLocationURI()))) {
                return;
            }
            link.delete(true, null);
        }
        if ((validationStatus = ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)link, locationPath).getSeverity()) != 4 && validationStatus != 8) {
            link.createLink(locationPath, 144, null);
        }
    }

    private void reflectionWorkspaceEndOperation(Workspace workspace, ISchedulingRule rule, boolean build, IProgressMonitor monitor) {
        try {
            if (EclipseUtils.isAtLeastEclipse47()) {
                Method endOperationM = workspace.getClass().getMethod("endOperation", ISchedulingRule.class, Boolean.TYPE);
                endOperationM.invoke((Object)workspace, rule, build);
            } else {
                Method endOperationM = workspace.getClass().getMethod("endOperation", ISchedulingRule.class, Boolean.TYPE, IProgressMonitor.class);
                endOperationM.invoke((Object)workspace, rule, build, monitor);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }
}

