/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search.favorites;

import java.util.List;

public class FavoriteQuery
implements Comparable<FavoriteQuery> {
    private String queryLabel;
    private List<String> searchedElements;
    private String languageKind;
    private boolean reportUnresolved;

    public FavoriteQuery(String languageKind, String label, boolean reportUnresolved) {
        this(null, languageKind, label, reportUnresolved);
    }

    public FavoriteQuery(List<String> searchedElements, String languageKind, String label, boolean reportUnresolved) {
        this.searchedElements = searchedElements;
        this.languageKind = languageKind;
        this.queryLabel = label;
        this.reportUnresolved = reportUnresolved;
    }

    public String getLanguageKind() {
        return this.languageKind;
    }

    public List<String> getSearchedElements() {
        return this.searchedElements;
    }

    public boolean isReportUnresolved() {
        return this.reportUnresolved;
    }

    public String getLabel() {
        return "[" + this.languageKind + "] " + this.queryLabel;
    }

    public String getQueryLabel() {
        return this.queryLabel;
    }

    public String getText() {
        if (this.searchedElements == null || this.searchedElements.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        int i = 0;
        for (String searchedString : this.searchedElements) {
            str.append(searchedString);
            if (i != this.searchedElements.size() - 1) {
                str.append("\n");
            }
            ++i;
        }
        return str.toString();
    }

    public void setSearchedElements(List<String> searchedElements) {
        this.searchedElements = searchedElements;
    }

    public void setLanguage(String languageKind) {
        this.languageKind = languageKind;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.queryLabel == null ? 0 : this.queryLabel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FavoriteQuery)) {
            return false;
        }
        FavoriteQuery otherQuery = (FavoriteQuery)obj;
        return this.queryLabel != null && this.queryLabel.equals(otherQuery.getQueryLabel());
    }

    public void setReportUnresolved(boolean reportUnresolved) {
        this.reportUnresolved = reportUnresolved;
    }

    @Override
    public int compareTo(FavoriteQuery o) {
        return this.getLabel().compareTo(o.getLabel());
    }
}

