/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search.favorites;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.favorites.FavoriteQuery;

public class RfFavoriteUtils {
    private static final String MM_FAVORITE_SEARCHES_TAG = "favorite-searches";
    private static final String MM_SEARCH_TAG = "search";
    private static final String MM_NAME_ATTR = "name";
    private static final String MM_LANGUAGE_ATTR = "language";
    private static final String MM_REPORT_UNRESOLVED_ATTR = "report-unresolved";
    private static final String MM_ELEMENT_TAG = "element";
    private static final String MM_ELEMENT_PATH_ATTR = "element-path";

    public static String getSerializedPredefinedSearchQueries(Map<String, List<FavoriteQuery>> queries) {
        if (queries == null) {
            return "";
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)MM_FAVORITE_SEARCHES_TAG);
        for (List<FavoriteQuery> queriesPerLanguage : queries.values()) {
            if (queriesPerLanguage == null || queries.isEmpty()) continue;
            for (FavoriteQuery predefinedQuery : queriesPerLanguage) {
                IMemento searchMemento = memento.createChild(MM_SEARCH_TAG);
                searchMemento.putString(MM_LANGUAGE_ATTR, predefinedQuery.getLanguageKind());
                searchMemento.putString(MM_NAME_ATTR, predefinedQuery.getQueryLabel());
                searchMemento.putBoolean(MM_REPORT_UNRESOLVED_ATTR, predefinedQuery.isReportUnresolved());
                List<String> searchedElements = predefinedQuery.getSearchedElements();
                if (searchedElements == null || searchedElements.isEmpty()) continue;
                for (String searchedElement : searchedElements) {
                    IMemento elementMemento = searchMemento.createChild(MM_ELEMENT_TAG);
                    elementMemento.putString(MM_ELEMENT_PATH_ATTR, searchedElement);
                }
            }
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException iOException) {}
        return writer.toString();
    }

    public static Map<String, List<FavoriteQuery>> getSearchQueries(String serializedPredefinedSearchesSets) {
        LinkedHashMap<String, List<FavoriteQuery>> result = new LinkedHashMap<String, List<FavoriteQuery>>();
        if (serializedPredefinedSearchesSets == null || serializedPredefinedSearchesSets.isEmpty()) {
            return result;
        }
        StringReader reader = new StringReader(serializedPredefinedSearchesSets);
        try {
            XMLMemento favoriteSearchesMemento = XMLMemento.createReadRoot((Reader)reader);
            if (favoriteSearchesMemento == null) {
                return result;
            }
            IMemento[] searchMementos = favoriteSearchesMemento.getChildren(MM_SEARCH_TAG);
            if (searchMementos == null || searchMementos.length == 0) {
                return result;
            }
            IMemento[] iMementoArray = searchMementos;
            int n = searchMementos.length;
            int n2 = 0;
            while (n2 < n) {
                Boolean reportUnresolved;
                String label;
                IMemento searchMemento = iMementoArray[n2];
                String language = searchMemento.getString(MM_LANGUAGE_ATTR);
                if (language != null && (label = searchMemento.getString(MM_NAME_ATTR)) != null && (reportUnresolved = searchMemento.getBoolean(MM_REPORT_UNRESOLVED_ATTR)) != null) {
                    ArrayList<FavoriteQuery> queriesPerLanguage = (ArrayList<FavoriteQuery>)result.get(language);
                    if (queriesPerLanguage == null) {
                        queriesPerLanguage = new ArrayList<FavoriteQuery>();
                        result.put(language, queriesPerLanguage);
                    }
                    FavoriteQuery query = new FavoriteQuery(language, label, reportUnresolved);
                    queriesPerLanguage.add(query);
                    IMemento[] elementMementos = searchMemento.getChildren(MM_ELEMENT_TAG);
                    if (elementMementos != null && elementMementos.length != 0) {
                        ArrayList<String> searchedElements = new ArrayList<String>();
                        IMemento[] iMementoArray2 = elementMementos;
                        int n3 = elementMementos.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMemento elementMemento = iMementoArray2[n4];
                            String elementPath = elementMemento.getString(MM_ELEMENT_PATH_ATTR);
                            searchedElements.add(elementPath);
                            ++n4;
                        }
                        query.setSearchedElements(searchedElements);
                    }
                }
                ++n2;
            }
        }
        catch (WorkbenchException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        return result;
    }
}

