/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.utils;

import java.util.HashMap;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public enum DVTColorUtil {
    INSTANCE;

    private final String FOREGROUND_CSS_KEY = "color";
    private final String BACKGROUND_CSS_KEY = "background-color";
    private final HashMap<RGB, Color> colorMap = new HashMap();
    private final HashMap<Integer, RGB> rgbMap = new HashMap();
    private Boolean fIsEclipseDarkTheme = null;

    private DVTColorUtil() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().disposeExec(() -> DVTColorUtil.this.colorMap.values().stream().forEach(color -> color.dispose()));
            }
        });
    }

    public RGB getRGB(int red, int green, int blue) {
        Integer rgbKey = blue << 16 | green << 8 | red;
        RGB cachedRGB = this.rgbMap.get(rgbKey);
        if (cachedRGB == null) {
            cachedRGB = new RGB(red, green, blue);
            this.rgbMap.put(rgbKey, cachedRGB);
        }
        return cachedRGB;
    }

    public Color getColor(RGB rgb) {
        Color cachedColor = this.colorMap.get(rgb);
        if (cachedColor != null && cachedColor.isDisposed()) {
            cachedColor = null;
        }
        if (cachedColor == null) {
            cachedColor = new Color((Device)Display.getDefault(), rgb);
            this.colorMap.put(rgb, cachedColor);
        }
        return cachedColor;
    }

    public Color getColor(int red, int green, int blue) {
        return this.getColor(this.getRGB(red, green, blue));
    }

    public Color blend(Color bg, Color fg, float factor) {
        RGB bgRGB = bg.getRGB();
        RGB fgRGB = fg.getRGB();
        float complement = 1.0f - factor;
        return this.getColor(new RGB((int)(complement * (float)bgRGB.red + factor * (float)fgRGB.red), (int)(complement * (float)bgRGB.green + factor * (float)fgRGB.green), (int)(complement * (float)bgRGB.blue + factor * (float)fgRGB.blue)));
    }

    public Color getSystemColor(int id) {
        return this.getSystemColor(Display.getDefault(), id);
    }

    public Color getSystemColor(Display display, int id) {
        if (display == null) {
            return this.getColor(0, 0, 0);
        }
        if (!this.isEclipseDarkTheme()) {
            return display.getSystemColor(id);
        }
        switch (id) {
            case 24: {
                return this.getColor(224, 226, 228);
            }
            case 25: {
                return this.getColor(41, 48, 52);
            }
        }
        return display.getSystemColor(id);
    }

    public boolean isEclipseDarkTheme() {
        if (this.fIsEclipseDarkTheme != null) {
            return this.fIsEclipseDarkTheme;
        }
        Object themeEngine = Display.getDefault().getData("org.eclipse.e4.ui.css.swt.theme");
        if (!(themeEngine instanceof IThemeEngine)) {
            return false;
        }
        ITheme activeTheme = ((IThemeEngine)themeEngine).getActiveTheme();
        if (activeTheme == null) {
            return false;
        }
        String themeId = activeTheme.getId();
        if (themeId == null) {
            return false;
        }
        this.fIsEclipseDarkTheme = themeId.contains("e4_dark");
        return this.fIsEclipseDarkTheme;
    }

    public void setForeground(Control widget, Color color) {
        if (widget == null) {
            return;
        }
        if (color == null) {
            color = this.getDefaultForeground(widget);
        }
        widget.setForeground(color);
        if (this.isEclipseDarkTheme()) {
            widget.setData("org.eclipse.e4.ui.css.disabled", (Object)true);
        }
    }

    public void setForeground(Control widget, Color color, boolean useDefaultBackground) {
        this.setForeground(widget, color);
        if (useDefaultBackground) {
            this.setBackground(widget, this.getDefaultBackground(widget));
        }
    }

    public void setForegroundRecursive(Control widget, Color color) {
        this.setForeground(widget, color);
        if (!(widget instanceof Composite)) {
            return;
        }
        Control[] controlArray = ((Composite)widget).getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.setForegroundRecursive(child, color);
            ++n2;
        }
    }

    public void setBackground(Control widget, Color color) {
        if (widget == null) {
            return;
        }
        if (color == null) {
            color = this.getDefaultBackground(widget);
        }
        widget.setBackground(color);
        if (this.isEclipseDarkTheme()) {
            widget.setData("org.eclipse.e4.ui.css.disabled", (Object)true);
        }
    }

    public void setBackground(Control widget, Color color, boolean useDefaultForeground) {
        this.setBackground(widget, color);
        if (useDefaultForeground) {
            this.setForeground(widget, this.getDefaultForeground(widget));
        }
    }

    public void setBackgroundRecursive(Control widget, Color color) {
        this.setBackground(widget, color);
        if (!(widget instanceof Composite)) {
            return;
        }
        Control[] controlArray = ((Composite)widget).getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.setBackgroundRecursive(child, color);
            ++n2;
        }
    }

    public Color getForeground(Control widget) {
        if (widget == null) {
            return null;
        }
        if (!this.isEclipseDarkTheme()) {
            return widget.getForeground();
        }
        if (Boolean.TRUE.equals(widget.getData("org.eclipse.e4.ui.css.disabled"))) {
            return widget.getForeground();
        }
        return this.getDefaultColor(widget, "color");
    }

    public Color getBackground(Control widget) {
        if (widget == null) {
            return null;
        }
        if (!this.isEclipseDarkTheme()) {
            return widget.getBackground();
        }
        if (Boolean.TRUE.equals(widget.getData("org.eclipse.e4.ui.css.disabled"))) {
            return widget.getBackground();
        }
        return this.getDefaultColor(widget, "background-color");
    }

    public Color getDefaultForeground(Control widget) {
        if (!this.isEclipseDarkTheme()) {
            return null;
        }
        return this.getDefaultColor(widget, "color");
    }

    public Color getDefaultBackground(Control widget) {
        if (!this.isEclipseDarkTheme()) {
            return null;
        }
        return this.getDefaultColor(widget, "background-color");
    }

    private Color getDefaultColor(Control widget, String cssKey) {
        if (widget == null || widget.isDisposed()) {
            return null;
        }
        Object themeEngine = Display.getDefault().getData("org.eclipse.e4.ui.css.swt.theme");
        if (!(themeEngine instanceof IThemeEngine)) {
            return this.getDefaultColor((Control)widget.getParent(), cssKey);
        }
        CSSStyleDeclaration style = ((IThemeEngine)themeEngine).getStyle((Object)widget);
        if (style == null) {
            return this.getDefaultColor((Control)widget.getParent(), cssKey);
        }
        CSSValue value = style.getPropertyCSSValue(cssKey);
        if (value == null) {
            return this.getDefaultColor((Control)widget.getParent(), cssKey);
        }
        String cssText = value.getCssText();
        if (cssText == null) {
            return this.getDefaultColor((Control)widget.getParent(), cssKey);
        }
        if (!cssText.startsWith("rgb(") || !cssText.endsWith(")")) {
            return this.getDefaultColor((Control)widget.getParent(), cssKey);
        }
        String rgbColors = cssText.substring(4, cssText.length() - 1);
        String[] rgb = rgbColors.split(",");
        if (rgb.length != 3) {
            return null;
        }
        try {
            int red = Integer.parseInt(rgb[0].trim());
            int green = Integer.parseInt(rgb[1].trim());
            int blue = Integer.parseInt(rgb[2].trim());
            return this.getColor(red, green, blue);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

