/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTThreadDumpCollectorJCMD {
    private static final String METHOD_DETACH = "detach";
    private static final String METHOD_EXECUTE_J_CMD = "executeJCmd";
    private static final String METHOD_ATTACH = "attach";
    private static final String CLASS_SUN_TOOLS_ATTACH_HOT_SPOT_VIRTUAL_MACHINE = "sun.tools.attach.HotSpotVirtualMachine";
    private static final String CLASS_COM_SUN_TOOLS_ATTACH_VIRTUAL_MACHINE = "com.sun.tools.attach.VirtualMachine";
    private static final PrintStream out;
    private static final PrintStream err;
    private static ZipOutputStream zipOS;
    private static String threadDumpZipLocation;

    static {
        Runtime.getRuntime().addShutdownHook(DVTThreadDumpCollectorJCMD.initializeHook());
        out = System.out;
        err = System.err;
    }

    public static StopHook initializeHook() {
        return new StopHook();
    }

    public static void main(String[] args) {
        String pid = args[0];
        String command = "Thread.print";
        int n = Integer.parseInt(args[1]);
        int tbs = Integer.parseInt(args[2]);
        String saveLocation = args[3];
        DVTThreadDumpCollectorJCMD.collectThreadDumps(pid, command, n, tbs, saveLocation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void collectThreadDumps(String pid, String command, int n, int tbs, String saveLocation) {
        try {
            Class<?> cVirtualMachine = Class.forName(CLASS_COM_SUN_TOOLS_ATTACH_VIRTUAL_MACHINE);
            if (cVirtualMachine == null) {
                throw new Exception("Unable to load class com.sun.tools.attach.VirtualMachine");
            }
            Class<?> cHotSpotVirtualMachine = Class.forName(CLASS_SUN_TOOLS_ATTACH_HOT_SPOT_VIRTUAL_MACHINE);
            if (cHotSpotVirtualMachine == null) {
                throw new Exception("Unable to load classsun.tools.attach.HotSpotVirtualMachine");
            }
            Method mAttach = cVirtualMachine.getDeclaredMethod(METHOD_ATTACH, String.class);
            if (mAttach == null) {
                throw new Exception("Unable to find method attach");
            }
            Object vm = mAttach.invoke(null, pid);
            if (!cHotSpotVirtualMachine.isInstance(vm)) {
                throw new Exception("Unable to invoke method attach");
            }
            out.println("Generating " + n + " thread dumps, " + tbs + " milliseconds apart.");
            String threadDumpFileName = "dvt_thread_dump_" + new Timestamp(System.currentTimeMillis()).toString().replace(" ", "_");
            threadDumpZipLocation = String.valueOf(saveLocation) + File.separator + threadDumpFileName + ".zip";
            File saveToLocationFile = new File(saveLocation);
            if (!saveToLocationFile.exists()) {
                saveToLocationFile.mkdirs();
            }
            zipOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(threadDumpZipLocation)));
            try {
                zipOS.putNextEntry(new ZipEntry(String.valueOf(threadDumpFileName) + ".log"));
                int i = 0;
                while (true) {
                    block28: {
                        if (i >= n) {
                            out.print("done.\n");
                            break;
                        }
                        Method mExecuteJCmd = cHotSpotVirtualMachine.getDeclaredMethod(METHOD_EXECUTE_J_CMD, String.class);
                        if (mExecuteJCmd == null) {
                            throw new Exception("Unable to find method executeJCmd");
                        }
                        Object mExecuteJCmdResult = mExecuteJCmd.invoke(vm, command);
                        if (mExecuteJCmdResult == null) throw new Exception("Unable to invoke method executeJCmd");
                        if (!(mExecuteJCmdResult instanceof InputStream)) {
                            throw new Exception("Unable to invoke method executeJCmd");
                        }
                        Throwable throwable = null;
                        Object var15_19 = null;
                        try {
                            InputStream in = (InputStream)mExecuteJCmdResult;
                            try {
                                try (Scanner scanner = new Scanner(in);){
                                    String timestamp = "[Thread Dump Sample]: " + new Timestamp(System.currentTimeMillis()) + "\n";
                                    zipOS.write(timestamp.getBytes(StandardCharsets.UTF_8));
                                    zipOS.write(scanner.useDelimiter("\\A").hasNext() ? scanner.useDelimiter("\\A").next().getBytes(StandardCharsets.UTF_8) : new byte[]{});
                                    zipOS.flush();
                                }
                                if (in == null) break block28;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (in == null) throw throwable;
                                in.close();
                                throw throwable;
                            }
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    Thread.sleep(tbs);
                    out.print(String.valueOf(i + 1) + ".. ");
                    ++i;
                }
            }
            catch (Exception e) {
                err.println(e);
            }
            Method mDetach = vm.getClass().getDeclaredMethod(METHOD_DETACH, new Class[0]);
            if (mDetach == null) {
                throw new Exception("Unable to find method detach");
            }
            mDetach.invoke(vm, new Object[0]);
            return;
        }
        catch (Exception e) {
            err.println(e);
        }
    }

    public static class StopHook
    extends Thread {
        @Override
        public void run() {
            try {
                if (zipOS == null) {
                    return;
                }
                zipOS.closeEntry();
                zipOS.close();
                out.println("");
                out.println("DVT thread dump log file is: " + threadDumpZipLocation);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
    }
}

