/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.utils;

import com.equo.chromium.swt.BrowserFunction;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OSInformation {
    private static final int BROWSER_SET_TEXT_TIMEOUT = 5000;
    private static final PrintStream out = System.out;
    private static final String TEST_PARAGRAPH_ID = "test-paragraph-id";
    private static final String TEST_PARAGRAPH_CONTENT = "TEST PARAGRAPH CONTENT";
    private static final String TEST_HTML = "<html lang='en'> <head> <meta charset='utf-8' /> <meta http-equiv='x-ua-compatible' content='ie=edge' /> <meta name='viewport' content='width=device-width, initial-scale=1' /> <meta content-uuid='CONTENT-UUID' /> <title>TITLE</title> </head> <body> <p id='test-paragraph-id'>TEST PARAGRAPH CONTENT</p> </body> </html>";
    private static final Set<String> WEBKIT_GTK_BLACKLIST = new HashSet<String>(Arrays.asList("2.20.5", "2.22.7"));

    public static void main(String[] args) {
        if (args != null && args.length == 1 && (args[0].equals("-test") || args[0].equals("-os") || args[0].equals("-swt") || args[0].equals("-gtk"))) {
            if (args[0].equals("-test")) {
                OSInformation.test();
            } else if (args[0].equals("-os")) {
                OSInformation.printOS();
            } else if (args[0].equals("-swt")) {
                OSInformation.printSWT();
            } else if (args[0].equals("-gtk")) {
                OSInformation.printGTK();
            }
        } else {
            out.println("Invalid arguments!");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void test() {
        block96: {
            display = null;
            shell = null;
            try {
                printedMessages = null;
                try {
                    var4_4 = null;
                    var5_6 = null;
                    try {
                        baStdOut = new ByteArrayOutputStream();
                        try {
                            psStdOut = new PrintStream(baStdOut);
                            try {
                                System.setOut(psStdOut);
                                display = new Display();
                                printedMessages = baStdOut.toString();
                            }
                            finally {
                                if (psStdOut != null) {
                                    psStdOut.close();
                                }
                            }
                            ** if (baStdOut == null) goto lbl-1000
                        }
                        catch (Throwable var5_7) {
                            if (var4_4 == null) {
                                var4_4 = var5_7;
                            } else if (var4_4 != var5_7) {
                                var4_4.addSuppressed(var5_7);
                            }
                            if (baStdOut != null) {
                                baStdOut.close();
                            }
                            throw var4_4;
                        }
lbl-1000:
                        // 1 sources

                        {
                            baStdOut.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (Throwable var5_8) {
                        if (var4_4 == null) {
                            var4_4 = var5_8;
                        } else if (var4_4 != var5_8) {
                            var4_4.addSuppressed(var5_8);
                        }
                        throw var4_4;
                    }
                }
                finally {
                    System.setOut(OSInformation.out);
                }
                if (printedMessages != null && printedMessages.contains("WARNING: SWT requires GTK")) {
                    throw new IllegalStateException("dvt_swt_test_failed F01__incompatible_gtk_version");
                }
            }
            catch (Throwable t) {
                if (t.getMessage().contains("dvt_swt_test_failed")) {
                    OSInformation.out.println(t.getMessage());
                } else {
                    OSInformation.out.println("dvt_swt_test_failed F02__display_failed");
                }
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable v0) {}
                return;
            }
            try {
                shell = new Shell(display, 8);
                shell.setBounds(0, 0, 5, 5);
                shell.setLayout((Layout)new FillLayout());
            }
            catch (Throwable v1) {
                OSInformation.out.println("dvt_swt_test_failed F03__shell_failed");
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable v2) {}
                return;
            }
            if (Objects.equals(System.getProperty("org.eclipse.swt.browser.DefaultType"), "none")) break block96;
            try {
                browser = new BrowserAdapter(shell, Objects.equals(System.getProperty("org.eclipse.swt.browser.DefaultType"), "chromium"));
            }
            catch (Throwable v3) {
                OSInformation.out.println("dvt_swt_test_failed E04__browser_failed");
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable v4) {}
                return;
            }
            progressListener = null;
            contentLoaded = new AtomicBoolean(false);
            try {
                contentUUID = UUID.randomUUID().toString();
                progressListener = new ProgressAdapter(){

                    public void completed(ProgressEvent event) {
                        String content = browser.getText();
                        if (content != null && content.contains(contentUUID)) {
                            contentLoaded.set(true);
                        }
                    }
                };
                browser.addProgressListener((ProgressListener)progressListener);
                browser.setText("<html lang='en'> <head> <meta charset='utf-8' /> <meta http-equiv='x-ua-compatible' content='ie=edge' /> <meta name='viewport' content='width=device-width, initial-scale=1' /> <meta content-uuid='CONTENT-UUID' /> <title>TITLE</title> </head> <body> <p id='test-paragraph-id'>TEST PARAGRAPH CONTENT</p> </body> </html>".replace("CONTENT-UUID", contentUUID));
            }
            catch (Throwable v5) {
                OSInformation.out.println("dvt_swt_test_failed E05__browser_text_failed");
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable v6) {}
                return;
            }
            try {
                try {
                    timedout = new AtomicBoolean(false);
                    OSInformation.runWatchdog(display, 5000L, timedout);
                    while (!(contentLoaded.get() || timedout.get() || browser.isDisposed() || shell.isDisposed() || display.isDisposed())) {
                        if (display.readAndDispatch() || contentLoaded.get() || timedout.get()) continue;
                        display.sleep();
                    }
                    browser.removeProgressListener((ProgressListener)progressListener);
                    if (!contentLoaded.get()) {
                        throw new IllegalStateException();
                    }
                }
                catch (Throwable v7) {
                    OSInformation.out.println("dvt_swt_test_failed E06__browser_text_timeout");
                    try {
                        if (display != null && !display.isDisposed()) {
                            display.dispose();
                        }
                    }
                    catch (Throwable v8) {}
                    return;
                }
            }
            catch (Throwable var9_13) {
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable v9) {}
                throw var9_13;
            }
            try {
                evalResult = browser.evaluate("return window.document.getElementById('test-paragraph-id').innerHTML;");
                if (!(evalResult instanceof String) || !"TEST PARAGRAPH CONTENT".equals(evalResult)) {
                    throw new IllegalStateException();
                }
            }
            catch (Throwable v10) {
                OSInformation.out.println("dvt_swt_test_failed E07__browser_get_element_failed");
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable v11) {}
                return;
            }
            try {
                browser.registerFunction("test_browser_function", OSInformation.testBrowserFunction());
                evalResult = browser.evaluate("return test_browser_function(2, 3);");
                if (!(evalResult instanceof Double) || (Double)evalResult != 6.0) {
                    throw new IllegalStateException();
                }
            }
            catch (Throwable v12) {
                OSInformation.out.println("dvt_swt_test_failed E08__browser_function_failed");
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable v13) {}
                return;
            }
            try {
                webkitVersion = System.getProperty("org.eclipse.swt.internal.webkitgtk.version");
                GTKversion = OSInformation.getGTKGTKVersion();
                if (webkitVersion != null && !webkitVersion.isEmpty() && GTKversion != null && GTKversion.startsWith("3.") && OSInformation.WEBKIT_GTK_BLACKLIST.contains(webkitVersion)) {
                    throw new IllegalStateException();
                }
            }
            catch (Throwable v14) {
                OSInformation.out.println("dvt_swt_test_failed E09__incompatible_webkitgtk_version");
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable v15) {}
                return;
            }
            try {
                browser.dispose();
            }
            catch (Throwable v16) {
                OSInformation.out.println("dvt_swt_test_failed E10__browser_dispose_failed");
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable v17) {}
                return;
            }
        }
        try {
            display.dispose();
        }
        catch (Throwable v18) {
            OSInformation.out.println("dvt_swt_test_failed E11__display_dispose_failed");
            try {
                if (display != null && !display.isDisposed()) {
                    display.dispose();
                }
            }
            catch (Throwable v19) {}
            return;
        }
        try {
            if (display != null && !display.isDisposed()) {
                display.dispose();
            }
        }
        catch (Throwable v20) {}
        OSInformation.out.println("dvt_swt_test_passed");
    }

    private static void printOS() {
        out.println("[CMD  ] lsb_release -d                                   = " + OSInformation.filter(Pattern.compile("Description:\\s*(.*)"), OSInformation.command("lsb_release", "-d")));
        out.println("[CMD  ] cat /etc/os-release                              = " + OSInformation.filter(Pattern.compile(".*NAME=\"(.*?)\".*VERSION=\"(.*?)\".*"), OSInformation.command("cat", "/etc/os-release")));
        out.println("[CMD  ] uname -a                                         = " + OSInformation.command("uname", "-a"));
        out.println("[PROP ] os.name                                          = " + System.getProperty("os.name"));
        out.println("[PROP ] os.version                                       = " + System.getProperty("os.version"));
        out.println("[PROP ] os.arch                                          = " + System.getProperty("os.arch"));
        out.println("[ENV  ] LD_LIBRARY_PATH                                  = " + System.getenv("LD_LIBRARY_PATH"));
        out.println("[PROP ] java.library.path                                = " + System.getProperty("java.library.path"));
        out.println("[CMD  ] GLIBC                                            = " + OSInformation.command(String.valueOf(System.getenv("DVT_HOME")) + "/bin/dvt_os_information.sh", "-glibc_version"));
        out.println("[CMD  ] GLIBCXX                                          = " + OSInformation.command(String.valueOf(System.getenv("DVT_HOME")) + "/bin/dvt_os_information.sh", "-glibcxx_version"));
        out.println("[API  ] OS.GLIB_VERSION                                  = " + OSInformation.getOSGlibVersion());
        out.println("[API  ] OS.GTK_VERSION                                   = " + OSInformation.getOSGTKVersion());
        out.println("[API  ] GTK.GTK_VERSION                                  = " + OSInformation.getGTKGTKVersion());
        out.println("[PROP ] org.eclipse.swt.internal.gtk.version             = " + System.getProperty("org.eclipse.swt.internal.gtk.version"));
        out.println("[ENV  ] SWT_GTK3                                         = " + System.getenv("SWT_GTK3"));
        out.println("[ENV  ] SWT_GTK4                                         = " + System.getenv("SWT_GTK4"));
        out.println("[ENV  ] DISPLAY                                          = " + System.getenv("DISPLAY"));
        out.println("[ENV  ] XDG_SESSION_TYPE                                 = " + System.getenv("XDG_SESSION_TYPE"));
    }

    private static void printSWT() {
        block16: {
            out.println("[MISC*] SWT JAR Version                                  = " + OSInformation.filter(Pattern.compile(".*org\\.eclipse\\.swt_(.*?).jar.*"), OSInformation.getCurrentClasspath()));
            out.println("[API *] SWT.getVersion()                                 = " + OSInformation.getSWTVersion());
            out.println("[ENV *] SWT_GTK3                                         = " + System.getenv("SWT_GTK3"));
            out.println("[ENV *] SWT_GTK4                                         = " + System.getenv("SWT_GTK4"));
            out.println("[ENV *] GTK_THEME                                        = " + System.getenv("GTK_THEME"));
            out.println("[ENV *] GTK2_RC_FILES                                    = " + System.getenv("GTK2_RC_FILES"));
            out.println("[ENV *] SWT_WEBKIT2                                      = " + System.getenv("SWT_WEBKIT2"));
            out.println("[PROP*] org.eclipse.swt.browser.DefaultType              = " + System.getProperty("org.eclipse.swt.browser.DefaultType"));
            Display display = null;
            Shell shell = null;
            try {
                try {
                    display = new Display();
                    out.println("[API  ] OS.X11                                           = " + OSInformation.getOSX11());
                    out.println("[PROP ] org.eclipse.swt.internal.gdk.backend             = " + System.getProperty("org.eclipse.swt.internal.gdk.backend"));
                    out.println("[API  ] OS.GLIB_VERSION                                  = " + OSInformation.getOSGlibVersion());
                    out.println("[API  ] OS.GTK_VERSION                                   = " + OSInformation.getOSGTKVersion());
                    out.println("[API  ] GTK.GTK_VERSION                                  = " + OSInformation.getGTKGTKVersion());
                    out.println("[PROP ] org.eclipse.swt.internal.gtk.version             = " + System.getProperty("org.eclipse.swt.internal.gtk.version"));
                    out.println("[API  ] OS.THEME_NAME                                    = " + OSInformation.getOSThemeName());
                    out.println("[PROP ] org.eclipse.swt.internal.gtk.theme               = " + System.getProperty("org.eclipse.swt.internal.gtk.theme"));
                    shell = new Shell(display, 8);
                    shell.setBounds(0, 0, 5, 5);
                    shell.setLayout((Layout)new FillLayout());
                    final BrowserAdapter browser = new BrowserAdapter(shell, Objects.equals(System.getProperty("org.eclipse.swt.browser.DefaultType"), "chromium"));
                    String webkitGTKVersion = System.getProperty("org.eclipse.swt.internal.webkitgtk.version");
                    out.println("[PROP ] org.eclipse.swt.internal.webkitgtk.version       = " + webkitGTKVersion);
                    final AtomicBoolean contentLoaded = new AtomicBoolean(false);
                    final String contentUUID = UUID.randomUUID().toString();
                    ProgressAdapter progressListener = new ProgressAdapter(){

                        public void completed(ProgressEvent event) {
                            String content = browser.getText();
                            if (content != null && content.contains(contentUUID)) {
                                contentLoaded.set(true);
                            }
                        }
                    };
                    browser.addProgressListener((ProgressListener)progressListener);
                    browser.setText(TEST_HTML.replace("CONTENT-UUID", contentUUID));
                    AtomicBoolean timedout = new AtomicBoolean(false);
                    OSInformation.runWatchdog(display, 5000L, timedout);
                    while (!(contentLoaded.get() || timedout.get() || browser.isDisposed() || shell.isDisposed() || display.isDisposed())) {
                        if (display.readAndDispatch() || contentLoaded.get() || timedout.get()) continue;
                        display.sleep();
                    }
                    browser.removeProgressListener((ProgressListener)progressListener);
                    Object evalResult1 = browser.evaluate("return window.document.getElementById('test-paragraph-id').innerHTML;");
                    out.println("[TEST ] Browser.evaluate(getElementById(...))            = " + TEST_PARAGRAPH_CONTENT.equals(evalResult1));
                    browser.registerFunction("test_browser_function", OSInformation.testBrowserFunction());
                    Object evalResult2 = browser.evaluate("return test_browser_function(2, 3);");
                    out.println("[TEST ] Browser.evaluate(test_browser_function(2, 3))    = " + evalResult2 + (evalResult2 != null ? " (" + evalResult2.getClass() + ")" : ""));
                    out.println("[TEST ] Browser.evaluate(navigator.userAgent)            = " + browser.evaluate("return navigator.userAgent;"));
                    if (WEBKIT_GTK_BLACKLIST.contains(webkitGTKVersion)) {
                        out.println("[MISC*] Incompatible webkitgtk version                   = " + webkitGTKVersion);
                    }
                    browser.dispose();
                    display.dispose();
                }
                catch (Throwable t) {
                    out.println("[EXCEPTION]");
                    t.printStackTrace(out);
                    try {
                        if (display != null && !display.isDisposed()) {
                            display.dispose();
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (display != null && !display.isDisposed()) {
                        display.dispose();
                    }
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                if (display != null && !display.isDisposed()) {
                    display.dispose();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static void printGTK() {
        String gtkVersion = OSInformation.getOSGTKVersion();
        if (gtkVersion != null) {
            out.println(gtkVersion);
            return;
        }
        gtkVersion = OSInformation.getGTKGTKVersion();
        if (gtkVersion != null) {
            out.println(gtkVersion);
            return;
        }
        gtkVersion = System.getProperty("org.eclipse.swt.internal.gtk.version");
        if (gtkVersion != null) {
            out.println(gtkVersion);
        }
    }

    private static Function<Object[], Object> testBrowserFunction() {
        Function<Object[], Object> runnable = arguments -> {
            if (arguments == null || ((Object[])arguments).length != 2 || !(arguments[0] instanceof Double) || !(arguments[1] instanceof Double)) {
                return null;
            }
            return (Double)arguments[0] * (Double)arguments[1];
        };
        return runnable;
    }

    private static String command(String ... command) {
        StringBuilder result = new StringBuilder();
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                result.append(String.valueOf(line) + " ");
            }
        }
        catch (Throwable throwable) {}
        return result.toString();
    }

    private static String filter(Pattern pattern, String text) {
        Matcher matcher = pattern.matcher(text = text.replaceAll("\\R+", " "));
        if (matcher.matches() && matcher.groupCount() > 0) {
            StringBuilder result = new StringBuilder();
            int i = 1;
            while (i <= matcher.groupCount()) {
                result.append(matcher.group(i)).append(' ');
                ++i;
            }
            return result.toString();
        }
        return text;
    }

    private static String getCurrentClasspath() {
        String classpath = System.getProperty("java.class.path");
        return classpath == null ? "" : classpath.replaceAll(File.pathSeparator, "\n");
    }

    private static final String getSWTVersion() {
        return OSInformation.getVersion("org.eclipse.swt.SWT", new String[]{"getVersion"});
    }

    public static final String getOSGTKVersion() {
        return OSInformation.getVersion("org.eclipse.swt.internal.gtk.OS", new String[]{"gtk_major_version", "gtk_minor_version", "gtk_micro_version"});
    }

    public static final String getGTKGTKVersion() {
        return OSInformation.getVersion("org.eclipse.swt.internal.gtk.GTK", new String[]{"gtk_get_major_version", "gtk_get_minor_version", "gtk_get_micro_version"});
    }

    private static final String getOSGlibVersion() {
        return OSInformation.getVersion("org.eclipse.swt.internal.gtk.OS", new String[]{"glib_major_version", "glib_minor_version", "glib_micro_version"});
    }

    private static final String getOSThemeName() {
        return OSInformation.runMethod("org.eclipse.swt.internal.gtk.OS", "getThemeName");
    }

    private static final String getOSX11() {
        return OSInformation.runMethod("org.eclipse.swt.internal.gtk.OS", "isX11");
    }

    private static final String getVersion(String className, String[] methodNames) {
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz != null) {
                StringBuilder version = new StringBuilder();
                String[] stringArray = methodNames;
                int n = methodNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String methodName = stringArray[n2];
                    Method method = clazz.getMethod(methodName, new Class[0]);
                    method.setAccessible(true);
                    Object result = method.invoke(null, new Object[0]);
                    version.append(result instanceof Integer ? (Integer)result : "x").append('.');
                    ++n2;
                }
                if (version.length() > 0) {
                    version.deleteCharAt(version.length() - 1);
                }
                return version.toString();
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private static final String runMethod(String className, String methodName) {
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz != null) {
                Method method = clazz.getMethod(methodName, new Class[0]);
                method.setAccessible(true);
                return String.valueOf(method.invoke(null, new Object[0]));
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private static final void runWatchdog(Display display, long timeout, AtomicBoolean signal) {
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {}
            signal.set(true);
            if (!display.isDisposed()) {
                display.wake();
            }
        });
        thread.setName("Sleep Watchdog");
        thread.setDaemon(true);
        thread.start();
    }

    private static final class BrowserAdapter {
        Browser SWTBrowser;
        com.equo.chromium.swt.Browser EquoBrowser;

        public BrowserAdapter(Shell shell, boolean useChromium) {
            if (useChromium) {
                this.EquoBrowser = new com.equo.chromium.swt.Browser((Composite)shell, 0);
            } else {
                this.SWTBrowser = new Browser((Composite)shell, 0);
            }
        }

        public void registerFunction(String name, Function<Object[], Object> runnable) {
            if (this.EquoBrowser != null) {
                new EquoBrowserFunction(this.EquoBrowser, name, runnable);
            } else {
                new SWTBrowserFunction(this.SWTBrowser, name, runnable);
            }
        }

        public void addProgressListener(ProgressListener progressListener) {
            if (this.EquoBrowser != null) {
                this.EquoBrowser.addProgressListener(progressListener);
            } else {
                this.SWTBrowser.addProgressListener(progressListener);
            }
        }

        public void setText(String text) {
            if (this.EquoBrowser != null) {
                this.EquoBrowser.setText(text);
            } else {
                this.SWTBrowser.setText(text);
            }
        }

        public void removeProgressListener(ProgressListener progressListener) {
            if (this.EquoBrowser != null) {
                this.EquoBrowser.removeProgressListener(progressListener);
            } else {
                this.SWTBrowser.removeProgressListener(progressListener);
            }
        }

        public Object evaluate(String script) {
            return this.EquoBrowser != null ? this.EquoBrowser.evaluate(script) : this.SWTBrowser.evaluate(script);
        }

        public String getText() {
            return this.EquoBrowser != null ? this.EquoBrowser.getText() : this.SWTBrowser.getText();
        }

        public boolean isDisposed() {
            return this.EquoBrowser != null ? this.EquoBrowser.isDisposed() : this.SWTBrowser.isDisposed();
        }

        public void dispose() {
            if (this.EquoBrowser != null) {
                this.EquoBrowser.dispose();
            } else {
                this.SWTBrowser.dispose();
            }
        }

        static class EquoBrowserFunction
        extends BrowserFunction {
            Function<Object[], Object> runnable;

            public EquoBrowserFunction(com.equo.chromium.swt.Browser browser, String name, Function<Object[], Object> function) {
                super(browser, name);
                this.runnable = function;
            }

            public Object function(Object[] arguments) {
                return this.runnable.apply(arguments);
            }
        }

        static class SWTBrowserFunction
        extends org.eclipse.swt.browser.BrowserFunction {
            Function<Object[], Object> runnable;

            public SWTBrowserFunction(Browser browser, String name, Function<Object[], Object> function) {
                super(browser, name);
                this.runnable = function;
            }

            public Object function(Object[] arguments) {
                return this.runnable.apply(arguments);
            }
        }
    }
}

