/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.utils;

import java.io.InputStream;
import java.io.OutputStream;

class Pipe
extends Thread {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private InputStream fInputStream;
    private OutputStream fOutputStream;
    private int fBufferSize;
    private boolean fDone;

    public Pipe(InputStream in, OutputStream out) {
        this(in, out, 1024);
    }

    public Pipe(InputStream in, OutputStream out, int bufferSize) {
        super("DVT InputStream -> OutputStream pipe");
        this.fInputStream = in;
        this.fOutputStream = out;
        this.fBufferSize = bufferSize;
    }

    public boolean isDone() {
        return this.fDone;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[this.fBufferSize];
        try {
            try {
                int size;
                while ((size = this.fInputStream.read(buffer)) != -1) {
                    this.fOutputStream.write(buffer, 0, size);
                }
            }
            catch (Exception exception) {
                this.fDone = true;
            }
        }
        finally {
            this.fDone = true;
        }
    }
}

