/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum StringEditorUtils {
    INSTANCE;


    public void openString(String title, String content) {
        StringInput input = new StringInput(new StringStorage(title, content));
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor");
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private class StringInput
    implements IStorageEditorInput {
        private final IStorage storage;

        public StringInput(IStorage storage) {
            this.storage = storage;
        }

        public IStorage getStorage() throws CoreException {
            return this.storage;
        }

        public String getName() {
            return this.storage.getName();
        }

        public String getToolTipText() {
            return this.getName();
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hash(this.storage);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringInput other = (StringInput)obj;
            return Objects.equals(this.storage, other.storage);
        }
    }

    private class StringStorage
    implements IStorage {
        private final String name;
        private final String content;

        public StringStorage(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.content.getBytes());
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return true;
        }

        public IPath getFullPath() {
            return null;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hash(this.content, this.name);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringStorage other = (StringStorage)obj;
            return Objects.equals(this.content, other.content) && Objects.equals(this.name, other.name);
        }
    }
}

