/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.help.ovmdoxygen;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.DVTHelp;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.help.HelpPopupMessage;
import ro.amiq.dvt.help.HelpPreferencePage;

public class OvmPreferencePage
extends HelpPreferencePage {
    private Composite fFieldComposite;
    private RadioGroupFieldEditor fRadioGroupFieldEditor;
    private Button fEnabledButton;

    public OvmPreferencePage() {
        super("OVM Doxygen", "ro.amiq.dvt.help.ovmdoxygen", "", "");
    }

    protected void createFieldEditors() {
        if (!DVTHelp.getHelpTest()) {
            return;
        }
        this.fRadioGroupFieldEditor = new RadioGroupFieldEditor("ro.amiq.dvt.help.ovmdoxygen.version", "\n\nSelect the OVM Version:\n", 1, (String[][])new String[][]{{"OVM 1.1", "11"}, {"OVM 2.0", "20"}, {"OVM 2.0.1", ""}}, this.fFieldComposite);
        this.addField((FieldEditor)this.fRadioGroupFieldEditor);
        this.fRadioGroupFieldEditor.setEnabled(!this.getPreferenceStore().getString("ro.amiq.dvt.help.ovmdoxygen.enabled").equals("false"), this.fFieldComposite);
    }

    protected void addContents(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fEnabledButton = new Button(parent, 32);
        this.fEnabledButton.setFont(parent.getFont());
        this.fEnabledButton.setText("Enable this manual");
        this.fEnabledButton.addMouseListener((MouseListener)new EnableHandler());
        this.fEnabledButton.setSelection(!this.getPreferenceStore().getString("ro.amiq.dvt.help.ovmdoxygen.enabled").equals("false"));
        this.fFieldComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fFieldComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 128, true, false);
        this.fFieldComposite.setLayoutData((Object)layoutData);
        this.fFieldComposite.setFont(parent.getFont());
        GridData labelData = new GridData(4, 4, true, true);
        Rectangle rect = parent.getMonitor().getClientArea();
        labelData.widthHint = rect.width / 4;
        Label label = new Label(parent, 64);
        label.setText("\n\n\nNote: Changes will be reflected in the table of contents only after you reopen the Help Contents window.");
        label.setFont(parent.getFont());
        label.setLayoutData((Object)labelData);
    }

    public boolean performOk() {
        String oldVersion = DVTPlugin.getDefault().getPreferenceStore().getString("ro.amiq.dvt.help.ovmdoxygen.version");
        this.fRadioGroupFieldEditor.store();
        String newVersion = DVTPlugin.getDefault().getPreferenceStore().getString("ro.amiq.dvt.help.ovmdoxygen.version");
        this.getPreferenceStore().setValue("ro.amiq.dvt.help.ovmdoxygen.enabled", "" + this.fEnabledButton.getSelection());
        boolean oldEnabled = !this.getPreferenceStore().getString("ro.amiq.dvt.help.ovmdoxygen.enabled").equals("false");
        boolean newEnabled = this.fEnabledButton.getSelection();
        if (oldVersion.equals(newVersion) && oldEnabled == newEnabled || DVTHelp.getHelpConfigurationDirectory() == null) {
            return true;
        }
        DVTPlugin.getDefault().getPreferenceStore().setValue("ro.amiq.dvt.help.reindex", true);
        new HelpPopupMessage().open();
        return true;
    }

    public class EnableHandler
    extends MouseAdapter {
        public void mouseUp(MouseEvent e) {
            OvmPreferencePage.this.fRadioGroupFieldEditor.setEnabled(OvmPreferencePage.this.fEnabledButton.getSelection(), OvmPreferencePage.this.fFieldComposite);
        }
    }
}

