/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.alg.IFactory;
import de.cau.cs.kieler.core.alg.InstancePool;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.ILayoutMetaData;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.options.GraphFeature;
import java.util.Map;

public final class LayoutAlgorithmData
implements ILayoutMetaData {
    public static final int MIN_PRIORITY = -536870912;
    public static final String DEFAULT_LAYOUTER_NAME = "<Unnamed Layout Algorithm>";
    private String id = "";
    private String name = "<Unnamed Layout Algorithm>";
    private InstancePool<AbstractLayoutProvider> providerPool;
    private String type = "";
    private String category = "";
    private String description = "";
    private Object imageData;
    private final Map<LayoutOptionData, Object> knownOptions = Maps.newHashMap();
    private final Map<String, Integer> supportedDiagrams = Maps.newHashMap();
    private final Map<GraphFeature, Integer> supportedFeatures = Maps.newEnumMap(GraphFeature.class);
    private final Map<GraphFeature, String> supportedFeaturesDescriptions = Maps.newEnumMap(GraphFeature.class);

    public boolean equals(Object obj) {
        if (obj instanceof LayoutAlgorithmData) {
            return this.id.equals(((LayoutAlgorithmData)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        if (this.name != null && this.name.length() > 0) {
            String categoryName = LayoutMetaDataService.getInstance().getCategoryName(this.category);
            if (categoryName == null) {
                return this.name;
            }
            return String.valueOf(this.name) + " (" + categoryName + ")";
        }
        return DEFAULT_LAYOUTER_NAME;
    }

    public void setOption(LayoutOptionData optionData, Object defaultValue) {
        if (optionData != null) {
            this.knownOptions.put(optionData, defaultValue);
        }
    }

    public boolean knowsOption(LayoutOptionData optionData) {
        return this.knownOptions.containsKey(optionData);
    }

    public Object getDefaultValue(LayoutOptionData optionData) {
        return this.knownOptions.get(optionData);
    }

    public void setDiagramSupport(String diagramType, int priority) {
        if (priority > -536870912) {
            this.supportedDiagrams.put(diagramType, priority);
        } else {
            this.supportedDiagrams.remove(diagramType);
        }
    }

    public int getDiagramSupport(String diagramType) {
        Integer result = this.supportedDiagrams.get(diagramType);
        if (result != null) {
            return result;
        }
        return -536870912;
    }

    public boolean supportsFeature(String diagramType) {
        return this.getDiagramSupport(diagramType) > -536870912;
    }

    public void setFeatureSupport(GraphFeature graphFeature, int priority) {
        if (priority > -536870912) {
            this.supportedFeatures.put(graphFeature, priority);
        } else {
            this.supportedFeatures.remove((Object)graphFeature);
        }
    }

    public int getFeatureSupport(GraphFeature graphFeature) {
        Integer result = this.supportedFeatures.get((Object)graphFeature);
        if (result != null) {
            return result;
        }
        return -536870912;
    }

    public boolean supportsFeature(GraphFeature graphFeature) {
        return this.getFeatureSupport(graphFeature) > -536870912;
    }

    public void setSupportedFeatureDescription(GraphFeature feature, String featureDescription) {
        if (featureDescription != null && !"".equals(featureDescription)) {
            this.supportedFeaturesDescriptions.put(feature, featureDescription);
        } else {
            this.supportedFeaturesDescriptions.remove((Object)feature);
        }
    }

    public String getSupportedFeatureDescription(GraphFeature feature) {
        return this.supportedFeaturesDescriptions.get((Object)feature);
    }

    @Override
    public void setId(String theid) {
        assert (theid != null);
        this.id = theid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String thename) {
        this.name = thename == null || thename.length() == 0 ? DEFAULT_LAYOUTER_NAME : thename;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String thedescription) {
        this.description = thedescription == null ? "" : thedescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void createPool(IFactory<AbstractLayoutProvider> providerFactory) {
        this.providerPool = new InstancePool(providerFactory);
    }

    public InstancePool<AbstractLayoutProvider> getInstancePool() {
        return this.providerPool;
    }

    public void setType(String thetype) {
        this.type = thetype;
    }

    public String getType() {
        return this.type;
    }

    public void setCategory(String thecategory) {
        this.category = thecategory == null ? "" : thecategory;
    }

    public String getCategory() {
        return this.category;
    }

    public Object getPreviewImage() {
        return this.imageData;
    }

    public void setPreviewImage(Object thepreviewImage) {
        this.imageData = thepreviewImage;
    }
}

