/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.alg.IFactory;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.core.properties.IPropertyValueProxy;
import de.cau.cs.kieler.core.properties.MapPropertyHolder;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.SemanticLayoutConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;

public abstract class LayoutConfigService {
    private static LayoutConfigService instance;
    private static IFactory<? extends LayoutConfigService> instanceFactory;
    private final Map<String, String> diagramTypeMap = Maps.newLinkedHashMap();
    private final Map<String, Map<String, Object>> id2OptionsMap = Maps.newHashMap();
    private final Multimap<String, SemanticLayoutConfig> semanticConfigMap = HashMultimap.create();
    private final List<ConfigData> configData = Lists.newLinkedList();
    private final MapPropertyHolder configProperties = new MapPropertyHolder();

    public static synchronized LayoutConfigService getInstance() {
        if (instance == null) {
            if (instanceFactory == null) {
                try {
                    Class.forName("de.cau.cs.kieler.kiml.service.ExtensionLayoutConfigService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException("The layout config service is not initialized yet. Load the plugin 'de.cau.cs.kieler.kiml.service' in order to initialize this service with Eclipse extensions.");
                }
            }
            instance = (LayoutConfigService)instanceFactory.create();
        }
        return instance;
    }

    public static void setInstanceFactory(IFactory<? extends LayoutConfigService> factory) {
        if (factory == null) {
            throw new NullPointerException("The given instance factory is null");
        }
        instanceFactory = factory;
        instance = null;
    }

    public IPropertyHolder getConfigProperties() {
        return this.configProperties;
    }

    protected final void addDiagramType(String id, String name) {
        this.diagramTypeMap.put(id, name);
    }

    public final void addOptionValue(String id, String optionId, Object value) {
        Map<String, Object> optionsMap = this.id2OptionsMap.get(id);
        if (optionsMap == null) {
            optionsMap = new LinkedHashMap<String, Object>();
            this.id2OptionsMap.put(id, optionsMap);
        }
        optionsMap.put(optionId, value);
    }

    public final void removeOptionValue(String id, String optionId) {
        Map<String, Object> optionsMap = this.id2OptionsMap.get(id);
        if (optionsMap != null) {
            optionsMap.remove(optionId);
        }
    }

    protected final void addSemanticConfig(String clazzName, SemanticLayoutConfig config) {
        this.semanticConfigMap.put((Object)clazzName, (Object)config);
    }

    public final String getDiagramTypeName(String id) {
        return this.diagramTypeMap.get(id);
    }

    public final List<Pair<String, String>> getDiagramTypes() {
        return Pair.fromMap(this.diagramTypeMap);
    }

    public final Map<String, Object> getOptionValues(String objectId) {
        Map<String, Object> optionsMap = this.id2OptionsMap.get(objectId);
        if (optionsMap != null) {
            LayoutMetaDataService dataService = LayoutMetaDataService.getInstance();
            for (Map.Entry<String, Object> entry : optionsMap.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof IPropertyValueProxy) || (value = ((IPropertyValueProxy)value).resolveValue((IProperty)dataService.getOptionData(entry.getKey()))) == null) continue;
                entry.setValue(value);
            }
            return Collections.unmodifiableMap(optionsMap);
        }
        return Collections.emptyMap();
    }

    public final Object getOptionValue(String objectId, String optionId) {
        Map<String, Object> optionsMap = this.id2OptionsMap.get(objectId);
        if (optionsMap != null) {
            Object value = optionsMap.get(optionId);
            if (value instanceof IPropertyValueProxy && (value = ((IPropertyValueProxy)value).resolveValue((IProperty)LayoutMetaDataService.getInstance().getOptionData(optionId))) != null) {
                optionsMap.put(optionId, value);
            }
            return value;
        }
        return null;
    }

    public final Map<String, Object> getOptionValues(EClass clazz) {
        if (clazz != null) {
            LayoutMetaDataService dataService = LayoutMetaDataService.getInstance();
            HashMap<String, Object> options = new HashMap<String, Object>();
            LinkedList<EClass> classes = new LinkedList<EClass>();
            classes.add(clazz);
            do {
                EClass c;
                Map<String, Object> optionsMap;
                if ((optionsMap = this.id2OptionsMap.get((c = (EClass)classes.removeFirst()).getInstanceTypeName())) != null) {
                    for (Map.Entry<String, Object> entry : optionsMap.entrySet()) {
                        Object value = entry.getValue();
                        if (value instanceof IPropertyValueProxy && (value = ((IPropertyValueProxy)value).resolveValue((IProperty)dataService.getOptionData(entry.getKey()))) != null) {
                            entry.setValue(value);
                        }
                        if (value == null) continue;
                        options.put(entry.getKey(), value);
                    }
                }
                classes.addAll((Collection<EClass>)c.getESuperTypes());
            } while (!classes.isEmpty());
            return options;
        }
        return Collections.emptyMap();
    }

    public final Object getOptionValue(EClass clazz, String optionId) {
        if (clazz != null) {
            LayoutMetaDataService dataService = LayoutMetaDataService.getInstance();
            LinkedList<EClass> classes = new LinkedList<EClass>();
            classes.add(clazz);
            do {
                EClass c;
                Map<String, Object> optionsMap;
                if ((optionsMap = this.id2OptionsMap.get((c = (EClass)classes.removeFirst()).getInstanceTypeName())) != null) {
                    Object value = optionsMap.get(optionId);
                    if (value instanceof IPropertyValueProxy && (value = ((IPropertyValueProxy)value).resolveValue((IProperty)dataService.getOptionData(optionId))) != null) {
                        optionsMap.put(optionId, value);
                    }
                    if (value != null) {
                        return value;
                    }
                }
                classes.addAll((Collection<EClass>)c.getESuperTypes());
            } while (!classes.isEmpty());
        }
        return null;
    }

    public final List<ILayoutConfig> getSemanticConfigs(Class<?> clazz) {
        if (clazz != null) {
            LinkedList<ILayoutConfig> configs = new LinkedList<ILayoutConfig>();
            LinkedList classes = new LinkedList();
            classes.add(clazz);
            do {
                Class c;
                if (this.semanticConfigMap.containsKey((Object)(c = (Class)classes.removeFirst()).getName())) {
                    configs.addAll(this.semanticConfigMap.get((Object)c.getName()));
                }
                if (c.getSuperclass() != null) {
                    classes.add(c.getSuperclass());
                }
                Class<?>[] classArray = c.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> i = classArray[n2];
                    classes.add(i);
                    ++n2;
                }
            } while (!classes.isEmpty());
            return configs;
        }
        return Collections.emptyList();
    }

    public final List<ILayoutConfig> getSemanticConfigs(EClass clazz) {
        if (clazz != null) {
            LinkedList<ILayoutConfig> configs = new LinkedList<ILayoutConfig>();
            LinkedList<EClass> classes = new LinkedList<EClass>();
            classes.add(clazz);
            do {
                EClass c;
                if (this.semanticConfigMap.containsKey((Object)(c = (EClass)classes.removeFirst()).getInstanceTypeName())) {
                    configs.addAll(this.semanticConfigMap.get((Object)c.getInstanceTypeName()));
                }
                classes.addAll((Collection<EClass>)c.getESuperTypes());
            } while (!classes.isEmpty());
            return configs;
        }
        return Collections.emptyList();
    }

    public final List<ILayoutConfig> getActiveConfigs() {
        LinkedList<ILayoutConfig> configs = new LinkedList<ILayoutConfig>();
        for (ConfigData data : this.configData) {
            if (data.activation != null && !((Boolean)this.configProperties.getProperty(data.activation)).booleanValue()) continue;
            configs.add(data.config);
        }
        return configs;
    }

    public final List<ConfigData> getConfigData() {
        return Collections.unmodifiableList(this.configData);
    }

    protected final void addCustomConfig(ConfigData data) {
        this.configData.add(data);
    }

    public static class ConfigData {
        private ILayoutConfig config;
        private IProperty<Boolean> activation;
        private String activationText;
        private Runnable activationAction;

        public ILayoutConfig getConfig() {
            return this.config;
        }

        public void setConfig(ILayoutConfig config) {
            this.config = config;
        }

        public IProperty<Boolean> getActivationProperty() {
            return this.activation;
        }

        public void setActivationProperty(IProperty<Boolean> prop) {
            this.activation = prop;
        }

        public String getActivationText() {
            return this.activationText;
        }

        public void setActivationText(String text) {
            this.activationText = text;
        }

        public Runnable getActivationAction() {
            return this.activationAction;
        }

        public void setActivationAction(Runnable action) {
            this.activationAction = action;
        }

        public String toString() {
            if (this.config == null) {
                return super.toString();
            }
            return this.config.getClass().getSimpleName();
        }
    }
}

