/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.alg.IFactory;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.LayoutTypeData;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class LayoutMetaDataService {
    public static final String DIAGRAM_TYPE_GENERAL = "de.cau.cs.kieler.layout.diagrams.general";
    private static LayoutMetaDataService instance;
    private static IFactory<? extends LayoutMetaDataService> instanceFactory;
    private final Registry registry = new Registry();
    private final Map<String, LayoutAlgorithmData> layoutAlgorithmMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutOptionData> layoutOptionMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutTypeData> layoutTypeMap = Maps.newLinkedHashMap();
    private final Map<String, String> categoryMap = Maps.newHashMap();
    private final Map<String, LayoutAlgorithmData> algorithmSuffixMap = Maps.newHashMap();
    private final Map<String, LayoutOptionData> optionSuffixMap = Maps.newHashMap();
    private final Map<String, LayoutTypeData> typeSuffixMap = Maps.newHashMap();

    public static synchronized LayoutMetaDataService getInstance() {
        if (instance == null) {
            if (instanceFactory == null) {
                try {
                    Class.forName("de.cau.cs.kieler.kiml.service.ExtensionLayoutMetaDataService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException("The layout meta data service is not initialized yet. Load the plugin 'de.cau.cs.kieler.kiml.service' in order to initialize this service with Eclipse extensions.");
                }
            }
            instance = (LayoutMetaDataService)instanceFactory.create();
        }
        return instance;
    }

    public static void setInstanceFactory(IFactory<? extends LayoutMetaDataService> factory) {
        if (factory == null) {
            throw new NullPointerException("The given instance factory is null");
        }
        instanceFactory = factory;
        instance = null;
    }

    protected final Registry getRegistry() {
        return this.registry;
    }

    public final LayoutAlgorithmData getAlgorithmData(String id) {
        return this.layoutAlgorithmMap.get(id);
    }

    public final Collection<LayoutAlgorithmData> getAlgorithmData() {
        return Collections.unmodifiableCollection(this.layoutAlgorithmMap.values());
    }

    public final LayoutAlgorithmData getAlgorithmDataBySuffix(String suffix) {
        LayoutAlgorithmData data = this.layoutAlgorithmMap.get(suffix);
        if (data == null && (data = this.algorithmSuffixMap.get(suffix)) == null) {
            for (LayoutAlgorithmData d : this.layoutAlgorithmMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                this.algorithmSuffixMap.put(suffix, d);
                return d;
            }
        }
        return data;
    }

    public final LayoutOptionData getOptionData(String id) {
        return this.layoutOptionMap.get(id);
    }

    public final Collection<LayoutOptionData> getOptionData() {
        return Collections.unmodifiableCollection(this.layoutOptionMap.values());
    }

    public final LayoutOptionData getOptionDataBySuffix(String suffix) {
        LayoutOptionData data = this.layoutOptionMap.get(suffix);
        if (data == null && (data = this.optionSuffixMap.get(suffix)) == null) {
            for (LayoutOptionData d : this.layoutOptionMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                this.optionSuffixMap.put(suffix, d);
                return d;
            }
        }
        return data;
    }

    public final List<LayoutOptionData> getOptionData(LayoutAlgorithmData algorithmData, LayoutOptionData.Target targetType) {
        LinkedList<LayoutOptionData> optionDataList = new LinkedList<LayoutOptionData>();
        for (LayoutOptionData optionData : this.layoutOptionMap.values()) {
            if (!algorithmData.knowsOption(optionData) && !LayoutOptions.ALGORITHM.equals((Object)optionData) || !optionData.getTargets().contains((Object)targetType)) continue;
            optionDataList.add(optionData);
        }
        return optionDataList;
    }

    public final LayoutTypeData getTypeData(String id) {
        return this.layoutTypeMap.get(id);
    }

    public final Collection<LayoutTypeData> getTypeData() {
        return Collections.unmodifiableCollection(this.layoutTypeMap.values());
    }

    public final LayoutTypeData getTypeDataBySuffix(String suffix) {
        LayoutTypeData data = this.layoutTypeMap.get(suffix);
        if (data == null && (data = this.typeSuffixMap.get(suffix)) == null) {
            for (LayoutTypeData d : this.layoutTypeMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                this.typeSuffixMap.put(suffix, d);
                return d;
            }
        }
        return data;
    }

    public final String getCategoryName(String id) {
        return this.categoryMap.get(id);
    }

    protected final class Registry {
        private Registry() {
        }

        public void addLayoutProvider(LayoutAlgorithmData providerData) {
            if (LayoutMetaDataService.this.layoutAlgorithmMap.containsKey(providerData.getId())) {
                LayoutMetaDataService.this.layoutAlgorithmMap.remove(providerData.getId());
            }
            LayoutMetaDataService.this.layoutAlgorithmMap.put(providerData.getId(), providerData);
        }

        public void addLayoutOption(LayoutOptionData optionData) {
            if (LayoutMetaDataService.this.layoutOptionMap.containsKey(optionData.getId())) {
                LayoutMetaDataService.this.layoutOptionMap.remove(optionData.getId());
            }
            LayoutMetaDataService.this.layoutOptionMap.put(optionData.getId(), optionData);
        }

        public void addLayoutType(LayoutTypeData typeData) {
            LayoutTypeData oldData = LayoutMetaDataService.this.layoutTypeMap.get(typeData.getId());
            if (oldData != null) {
                typeData.getLayouters().addAll(oldData.getLayouters());
                LayoutMetaDataService.this.layoutTypeMap.remove(typeData.getId());
            }
            LayoutMetaDataService.this.layoutTypeMap.put(typeData.getId(), typeData);
        }

        public void addCategory(String id, String name) {
            LayoutMetaDataService.this.categoryMap.put(id, name);
        }
    }
}

