/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.IDataObject;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.ILayoutMetaData;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public final class LayoutOptionData
implements ILayoutMetaData,
IProperty<Object>,
Comparable<IProperty<?>> {
    public static final String BOOLEAN_LITERAL = "boolean";
    public static final String INT_LITERAL = "int";
    public static final String STRING_LITERAL = "string";
    public static final String FLOAT_LITERAL = "float";
    public static final String ENUM_LITERAL = "enum";
    public static final String ENUMSET_LITERAL = "enumset";
    public static final String OBJECT_LITERAL = "object";
    public static final String DEFAULT_OPTION_NAME = "<Unnamed Option>";
    private String id = "";
    private Object defaultValue;
    private Type type = Type.UNDEFINED;
    private String name = "";
    private String description = "";
    private Set<Target> targets = Collections.emptySet();
    private List<Pair<LayoutOptionData, Object>> dependencies = Lists.newLinkedList();
    private Class<?> clazz;
    private String[] choices;
    private boolean advanced;
    private Object lowerBound;
    private Object upperBound;
    private float variance = 1.0f;
    private static final String[] BOOLEAN_CHOICES = new String[]{"false", "true"};

    private void checkEnumClass() {
        if (this.clazz == null || !this.clazz.isEnum()) {
            throw new IllegalStateException("Enumeration class expected for layout option " + this.id);
        }
    }

    private IDataObject createDataInstance() {
        if (this.clazz == null || !IDataObject.class.isAssignableFrom(this.clazz)) {
            throw new IllegalStateException("IDataType class expected for layout option " + this.id);
        }
        try {
            return (IDataObject)this.clazz.newInstance();
        }
        catch (InstantiationException exception) {
            throw new IllegalStateException("The data object for layout option " + this.id + " cannot be instantiated.", exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("The data object for layout option " + this.id + " cannot be accessed.", exception);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof LayoutOptionData) {
            return this.id.equals(((LayoutOptionData)obj).id);
        }
        if (obj instanceof IProperty) {
            return this.id.equals(((IProperty)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(IProperty<?> other) {
        return this.id.compareTo(other.getId());
    }

    public String toString() {
        if (this.name != null && this.name.length() > 0) {
            return this.name;
        }
        return this.id;
    }

    public void setType(String typeLiteral) {
        if (BOOLEAN_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.BOOLEAN;
        } else if (INT_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.INT;
        } else if (STRING_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.STRING;
        } else if (FLOAT_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.FLOAT;
        } else if (ENUM_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.ENUM;
        } else if (ENUMSET_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.ENUMSET;
        } else if (OBJECT_LITERAL.equalsIgnoreCase(typeLiteral)) {
            this.type = Type.OBJECT;
        } else {
            throw new IllegalArgumentException("The given type literal is invalid.");
        }
    }

    public Object parseValue(String valueString) {
        if (valueString == null || valueString.equals("null")) {
            return null;
        }
        if (valueString.length() == 0 && this.type != Type.ENUMSET) {
            return null;
        }
        switch (this.type) {
            case BOOLEAN: {
                return Boolean.valueOf(valueString);
            }
            case INT: {
                try {
                    return Integer.valueOf(valueString);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case STRING: {
                return valueString;
            }
            case FLOAT: {
                try {
                    return Float.valueOf(valueString);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case ENUM: {
                this.checkEnumClass();
                return this.enumForString(valueString);
            }
            case ENUMSET: {
                this.checkEnumClass();
                return this.enumSetForStringArray(this.clazz, valueString);
            }
            case OBJECT: {
                try {
                    IDataObject value = this.createDataInstance();
                    value.parse(valueString);
                    return value;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
        }
        throw new IllegalStateException("Invalid type set for this layout option.");
    }

    private <E extends Enum<E>> EnumSet<E> enumSetForStringArray(Class<E> leClazz, String leString) {
        String[] components;
        EnumSet<Enum> set = EnumSet.noneOf(leClazz);
        String[] stringArray = components = leString.split("[\\[\\]\\s,]+");
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            if (component.trim().length() != 0) {
                Object o = this.enumForString(component);
                if (o == null) {
                    return null;
                }
                set.add((Enum)leClazz.cast(o));
            }
            ++n2;
        }
        return set;
    }

    private Object enumForString(String leString) {
        try {
            Object value = Enum.valueOf(this.clazz, leString);
            return value;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                int index = Integer.parseInt(leString);
                ?[] constants = this.clazz.getEnumConstants();
                if (index >= 0 && index < constants.length) {
                    return constants[index];
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return null;
        }
    }

    public void parseRemoteEnumValues(String valueString) {
        Vector<String> tmp = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(valueString, " ");
        while (tokenizer.hasMoreTokens()) {
            tmp.add(tokenizer.nextToken());
        }
        this.choices = tmp.toArray(new String[tmp.size()]);
    }

    public Object getDefaultDefault() {
        switch (this.type) {
            case STRING: {
                return "";
            }
            case BOOLEAN: {
                return Boolean.FALSE;
            }
            case INT: {
                return 0;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case ENUM: {
                this.checkEnumClass();
                Enum[] enums = (Enum[])this.clazz.getEnumConstants();
                return enums[0];
            }
            case ENUMSET: {
                this.checkEnumClass();
                return EnumSet.noneOf(this.clazz);
            }
            case OBJECT: {
                return null;
            }
        }
        throw new IllegalStateException("Invalid type set for this layout option.");
    }

    public String[] getChoices() {
        if (this.choices == null) {
            switch (this.type) {
                case ENUM: 
                case ENUMSET: {
                    this.checkEnumClass();
                    Enum[] enums = (Enum[])this.clazz.getEnumConstants();
                    this.choices = new String[enums.length];
                    int i = 0;
                    while (i < enums.length) {
                        this.choices[i] = enums[i].toString();
                        ++i;
                    }
                    break;
                }
                case BOOLEAN: {
                    this.choices = BOOLEAN_CHOICES;
                    break;
                }
                default: {
                    this.choices = new String[0];
                }
            }
        }
        return this.choices;
    }

    public Enum<?> getEnumValue(int intValue) {
        switch (this.type) {
            case ENUM: 
            case ENUMSET: {
                this.checkEnumClass();
                Enum[] enums = (Enum[])this.clazz.getEnumConstants();
                return enums[intValue];
            }
        }
        return null;
    }

    public void setTargets(String targetsString) {
        this.targets = EnumSet.noneOf(Target.class);
        if (targetsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(targetsString, ", \t");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equalsIgnoreCase(Target.PARENTS.toString())) {
                    this.targets.add(Target.PARENTS);
                    continue;
                }
                if (token.equalsIgnoreCase(Target.NODES.toString())) {
                    this.targets.add(Target.NODES);
                    continue;
                }
                if (token.equalsIgnoreCase(Target.EDGES.toString())) {
                    this.targets.add(Target.EDGES);
                    continue;
                }
                if (token.equalsIgnoreCase(Target.PORTS.toString())) {
                    this.targets.add(Target.PORTS);
                    continue;
                }
                if (!token.equalsIgnoreCase(Target.LABELS.toString())) continue;
                this.targets.add(Target.LABELS);
            }
        }
    }

    public Set<Target> getTargets() {
        return this.targets;
    }

    public List<Pair<LayoutOptionData, Object>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setId(String theid) {
        assert (theid != null);
        this.id = theid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setType(Type thetype) {
        this.type = thetype;
        switch (thetype) {
            case STRING: {
                this.clazz = String.class;
                break;
            }
            case BOOLEAN: {
                this.clazz = Boolean.class;
                break;
            }
            case INT: {
                this.clazz = Integer.class;
                break;
            }
            case FLOAT: {
                this.clazz = Float.class;
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void setName(String thename) {
        this.name = thename == null || thename.length() == 0 ? DEFAULT_OPTION_NAME : thename;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String thedescription) {
        this.description = thedescription == null ? "" : thedescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Object getDefault() {
        if (this.defaultValue instanceof Cloneable) {
            try {
                Method cloneMethod = this.defaultValue.getClass().getMethod("clone", new Class[0]);
                return cloneMethod.invoke(this.defaultValue, new Object[0]);
            }
            catch (Exception exception) {
                return this.defaultValue;
            }
        }
        return this.defaultValue;
    }

    public Comparable<? super Object> getLowerBound() {
        if (this.lowerBound instanceof Comparable) {
            return (Comparable)this.lowerBound;
        }
        return Property.NEGATIVE_INFINITY;
    }

    public void setLowerBound(Object lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Comparable<? super Object> getUpperBound() {
        if (this.upperBound instanceof Comparable) {
            return (Comparable)this.upperBound;
        }
        return Property.POSITIVE_INFINITY;
    }

    public void setUpperBound(Object upperBound) {
        this.upperBound = upperBound;
    }

    public void setDefault(Object thedefaultValue) {
        this.defaultValue = thedefaultValue;
    }

    public Class<?> getOptionClass() {
        return this.clazz;
    }

    public void setOptionClass(Class<?> theclazz) {
        this.clazz = theclazz;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean theadvanced) {
        this.advanced = theadvanced;
    }

    public float getVariance() {
        return this.variance;
    }

    public void setVariance(float variance) {
        this.variance = variance;
    }

    public static enum Target {
        PARENTS,
        NODES,
        EDGES,
        PORTS,
        LABELS;

    }

    public static enum Type {
        UNDEFINED,
        BOOLEAN,
        INT,
        STRING,
        FLOAT,
        ENUM,
        ENUMSET,
        OBJECT;


        public String literal() {
            switch (this) {
                case BOOLEAN: {
                    return LayoutOptionData.BOOLEAN_LITERAL;
                }
                case INT: {
                    return LayoutOptionData.INT_LITERAL;
                }
                case STRING: {
                    return LayoutOptionData.STRING_LITERAL;
                }
                case FLOAT: {
                    return LayoutOptionData.FLOAT_LITERAL;
                }
                case ENUM: {
                    return LayoutOptionData.ENUM_LITERAL;
                }
                case ENUMSET: {
                    return LayoutOptionData.ENUMSET_LITERAL;
                }
                case OBJECT: {
                    return LayoutOptionData.OBJECT_LITERAL;
                }
            }
            return this.toString();
        }
    }
}

